/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import net.souko105.flashserver.HttpParameters;
import net.souko105.flashserver.HttpRequestHeader;

public class HttpRequestBody {
    private HttpParameters parameters;
    private HttpRequestHeader header;
    private byte[] bodyData;

    public HttpRequestBody(HttpRequestHeader header) {
        this.header = header;
        this.parameters = new HttpParameters(this);
    }

    public HttpRequestBody(HttpRequestHeader header, byte[] bodyData) {
        this.header = header;
        this.bodyData = bodyData;
        this.parameters = new HttpParameters(this);
    }

    void initParameters() {
        String contType;
        if (this.header.getQueryString() != null) {
            this.parseRequestQuery(this.header.getQueryString(), "UTF-8");
        }
        if (this.bodyData != null && this.header.getMethod().equals("POST") && (contType = this.header.getHeader("Content-Type")) != null && contType.equals("application/x-www-form-urlencoded")) {
            try {
                this.parseRequestQuery(new String(this.bodyData, "ISO-8859-1"), this.parameters.getCharacterEncodin());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void parseRequestQuery(String query, String encode) {
        StringTokenizer paramToken = new StringTokenizer(query, "&", false);
        while (paramToken.hasMoreElements()) {
            String param = paramToken.nextToken();
            StringTokenizer token = new StringTokenizer(param, "=", false);
            String key = token.nextToken();
            String value = null;
            if (token.hasMoreTokens()) {
                value = token.nextToken();
                try {
                    key = this.decode(key, encode);
                    value = this.decode(value, encode);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            this.parameters.addParameter(key, value);
        }
    }

    private String decode(String value, String encode) throws UnsupportedEncodingException {
        value = URLDecoder.decode(value, "ISO-8859-1");
        value = new String(value.getBytes("ISO-8859-1"), encode);
        return value;
    }

    public byte[] getBodyData() {
        return this.bodyData;
    }

    public HttpRequestHeader getHeader() {
        return this.header;
    }

    public HttpParameters getParameters() {
        return this.parameters;
    }
}

