package jp.sourceforge.sos.cytoq.resultImage;

import java.awt.GridLayout;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;

@SuppressWarnings("serial")
public class ViewPanelAnimation extends JPanel implements ILinkModel, ILinkContainer{

	private JLabel jLabel3 = null;
	private JLabel jLabel4 = null;
	private JLabel jLabel5 = null;
	
	private JSpinner jSpinner = null;
	
	private JCheckBox jCheckBox = null;
	private JComboBox	jComboBox;
	private ModelResultImage	modelResultImage;
	
	/**
	 * This method initializes 
	 * 
	 */
	public ViewPanelAnimation() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {		
  		jLabel5 = new JLabel();
		jLabel5.setText("color: ");
		jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		jLabel4 = new JLabel();
		jLabel4.setText("magnification: ");
		jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		jLabel3 = new JLabel();
		jLabel3.setText("show: ");
		jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.setRows(3);
		gridLayout1.setColumns(2);
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Animation", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
		this.setLayout(gridLayout1);
		this.add(jLabel3, null);
		this.add(getJCheckBox(), null);
		this.add(jLabel4, null);
		this.add(getJSpinner(), null);
		this.add(jLabel5, null);
		this.add(getJComboBox(), null);
	}


	/**
	 * This method initializes jCheckBox	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJCheckBox() {
		if (jCheckBox==null) {
			jCheckBox = new JCheckBox();
			jCheckBox.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					boolean b = jCheckBox.isSelected();
					jSpinner.setEnabled(b);
					jComboBox.setEnabled(b);
				}
			});
		}
		return jCheckBox;
	}
	

	/**
	 * This method initializes jComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBox() {
		if (jComboBox==null) {
			jComboBox = new JComboBox();
			jComboBox.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					int index = jComboBox.getSelectedIndex();
					modelResultImage.setIndexAnimation(index+1);
				}
			});
		}
		return jComboBox;
	}

	/**
	 * This method initializes jSpinner	
	 * 	
	 * @return javax.swing.JSpinner	
	 */
	private JSpinner getJSpinner() {
		if (jSpinner==null) {
			jSpinner = new JSpinner();
			final SpinnerNumberModel model = new SpinnerNumberModel(1.0, 0.1, 2.0, 0.1);
			jSpinner.setModel(model);
			jSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					modelResultImage.setMagnification((Double)model.getValue());
				}
			});
		}
		return jSpinner;
	}
	
	public void setModel(IComponent model) {
		modelResultImage = (ModelResultImage)model;
		
		jComboBox.setModel(modelResultImage.getColorsModel());
		jCheckBox.setSelected(true);
	}

	public String getContainer() {
		return "jPanelOption";
	}

	public Object getConstraints() {
		return NO_CONSTRAINT;
	}
}
