package jp.sourceforge.sos.cytoq.resultImage;

import java.awt.GridLayout;

import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;

import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.BoxLayout;

@SuppressWarnings("serial")
class ViewPanel extends JPanel implements ILinkModel, ILinkContainer {

	private ModelResultImage modelResultImage;

	private JCheckBox jCheckBox1 = null;

	private JCheckBox jCheckBox2 = null;

	private JCheckBox jCheckBox3 = null;

	private JSpinner jSpinner = null;

	private JPanel jPanel = null;

	private JLabel jLabel = null;

	private JPanel jPanel1 = null;

	ViewPanel() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null,
				"Result images",
				javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
				javax.swing.border.TitledBorder.DEFAULT_POSITION,
				new java.awt.Font("Dialog", java.awt.Font.BOLD, 12),
				java.awt.Color.blue));
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		this.add(getJPanel1(), null);
		this.add(getJPanel(), null);
	}

	/**
	 * This method initializes jCheckBox1
	 * 
	 * @return javax.swing.JCheckBox
	 */
	private JCheckBox getJCheckBox1() {
		if (jCheckBox1 == null) {
			jCheckBox1 = new JCheckBox();
			jCheckBox1.setText("original");
			jCheckBox1.setSelected(true);
			jCheckBox1.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					setVisible(0, e);
				}
			});
		}
		return jCheckBox1;
	}

	/**
	 * This method initializes jCheckBox2
	 * 
	 * @return javax.swing.JCheckBox
	 */
	private JCheckBox getJCheckBox2() {
		if (jCheckBox2 == null) {
			jCheckBox2 = new JCheckBox();
			jCheckBox2.setText("initial");
			jCheckBox2.setSelected(true);
			jCheckBox2.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					setVisible(1, e);
				}
			});
		}
		return jCheckBox2;
	}

	/**
	 * This method initializes jCheckBox3
	 * 
	 * @return javax.swing.JCheckBox
	 */
	private JCheckBox getJCheckBox3() {
		if (jCheckBox3 == null) {
			jCheckBox3 = new JCheckBox();
			jCheckBox3.setText("final");
			jCheckBox3.setSelected(true);
			jCheckBox3.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					setVisible(2, e);
				}
			});
		}
		return jCheckBox3;
	}

	public void setModel(IComponent model) {
		modelResultImage = (ModelResultImage) model;
		jSpinner.setValue(1.0);
	}

	public String getContainer() {
		return "jPanelOption";
	}

	public Object getConstraints() {
		return new Integer(0);
	}

	/**
	 * @param i
	 * @param e
	 */
	private void setVisible(int i, java.awt.event.ItemEvent e) {
		AbstractButton button = (AbstractButton) e.getSource();
		modelResultImage.setImageEnabled(i, button.isSelected());
	}

	/**
	 * This method initializes jSpinner
	 * 
	 * @return javax.swing.JSpinner
	 */
	private JSpinner getJSpinner() {
		if (jSpinner == null) {
			jSpinner = new JSpinner();
			final SpinnerNumberModel model = new SpinnerNumberModel(0.1, 0.1,
					2.0, 0.1);
			jSpinner.setModel(model);
			jSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					modelResultImage
							.setMagnification((Double) model.getValue());
				}
			});
		}
		return jSpinner;
	}

	/**
	 * This method initializes jPanel
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			GridLayout gridLayout1 = new GridLayout();
			gridLayout1.setRows(1);
			jLabel = new JLabel();
			jLabel.setText("magnification: ");
			jLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
			jPanel = new JPanel();
			jPanel.setLayout(gridLayout1);
			jPanel.add(jLabel, null);
			jPanel.add(getJSpinner(), null);
		}
		return jPanel;
	}

	/**
	 * This method initializes jPanel1
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel1() {
		if (jPanel1 == null) {
			jPanel1 = new JPanel();
			jPanel1.add(getJCheckBox1(), null);
			jPanel1.add(getJCheckBox2(), null);
			jPanel1.add(getJCheckBox3(), null);
		}
		return jPanel1;
	}

} // @jve:decl-index=0:visual-constraint="193,-2"
