package jp.sourceforge.sos.cytoq.resultImage;

import java.awt.Rectangle;
import java.io.File;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.colorFinal.ModelColorFinal;
import jp.sourceforge.sos.cytoq.main.AbstractFileHandler;
import jp.sourceforge.sos.cytoq.message.IAnimation;
import jp.sourceforge.sos.cytoq.message.IEndSection;
import jp.sourceforge.sos.cytoq.message.IInitProcess;
import jp.sourceforge.sos.cytoq.message.IInitSection;
import jp.sourceforge.sos.cytoq.message.IResize;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.lib.image.LabeledImage;
import jp.sourceforge.sos.lib.io.Extension;
import jp.sourceforge.sos.lib.window.JImageArrayFrame;

@SuppressWarnings("unchecked")
public class ModelResultImage extends AbstractModel<ModelColorFinal> implements
		IInitProcess, IInitSection, IAnimation, IEndSection, IResize {

	private AbstractResultImage[]	resultImages	= new AbstractResultImage[3];

	private JImageArrayFrame		frame			= new JImageArrayFrame();

	private double					magnification;

	private String					pathSave;

	private int indexAnimation;

	@Override
	protected void initModel() {
		resultImages[0] = new ImageOriginal("Original");
		resultImages[1] = new ImageColorPanel(modelParent.getInitColors());
		resultImages[2] = new ImageColorPanel(modelParent.getColorModel());

		setIndexAnimation(1);

		for (int i = 0; i<resultImages.length; i++) {
			frame.addImage(resultImages[i]);		
		}

		resultImages[0].setPrefix("");
		resultImages[1].setPrefix("(INIT)");
		resultImages[2].setPrefix("(FINAL)");
	}

	public void observeInitSection(AbstractAlgorithm changed) {
		LabeledImage image = changed.getLabeledImage();
		
		frame.clearImage();
		frame.addImage(resultImages[indexAnimation]);
		frame.updateScrollBar();
		
		int w = (int)(magnification*image.getWidth());
		int h = (int)(magnification*image.getHeight());
		frame.setCanvasSize(w, h);
		frame.pack();
		frame.setVisible(true);
	}

	public void observeAnimation(AbstractAlgorithm changed) {
		resultImages[indexAnimation].createImage(changed.getLabeledImage());
		frame.setCurrentImage(0);
	}

	public void observeEndSection(AbstractAlgorithm changed) {
		frame.clearImage();
		for (int i = 0; i<resultImages.length; i++) {
			if (resultImages[i].isEnabled()){
				resultImages[i].createImage(changed.getLabeledImage());
				frame.addImage(resultImages[i]);
			}
		}
		frame.updateScrollBar();
		saveImages(changed.getName());
	}

	private void saveImages(String name) {
		if (pathSave==null) {
			return;
		}
		for (int i = 1; i<resultImages.length; i++) {
			if (resultImages[i].isEnabled()) {
				StringBuilder builder = new StringBuilder();
				builder.append(pathSave);
				builder.append(resultImages[i].getPrefix());
				builder.append(Extension.replace(name, "png"));
				File file = new File(builder.toString());
				resultImages[i].save(file, "image/png");
			}
		}
	}

	public void setMagnification(double value) {
		magnification = value;
	}

	ComboBoxModel getColorsModel() {
		DefaultComboBoxModel model = new DefaultComboBoxModel();
		model.addElement(modelParent.getInitColors());
		model.addElement(modelParent.getColorModel());
		return model;
	}

	public void setIndexAnimation(int index) {
		indexAnimation = index;
	}

	public void observeResize(Rectangle changed) {
		frame.setLocation(changed.x+changed.width, changed.y);
	}

	public void observeInitProcess(AbstractFileHandler changed) {
		pathSave = changed.getPath();
	}

	public void setImageEnabled(int i, boolean b) {
		resultImages[i].setEnabled(b);
	}
}
