package jp.sourceforge.sos.cytoq.resultImage;

import java.awt.image.BufferedImage;

import jp.sourceforge.sos.lib.color.ColorPanelModel;
import jp.sourceforge.sos.lib.image.LabeledImage;



public class ImageColorPanel extends AbstractResultImage {

	private ColorPanelModel	colorModel;

	public ImageColorPanel(ColorPanelModel model) {
		super(model.toString());
		colorModel = model;
	}

	@Override
	BufferedImage fromLabeledImage(LabeledImage labeledImage) {
		int[] colors = colorModel.getColorInt();
		return labeledImage.createImage(colors);
	}

}
