/**
 * 
 */
package jp.sourceforge.sos.cytoq.resultImage;

import java.awt.image.BufferedImage;

import jp.sourceforge.sos.lib.image.LabeledImage;
import jp.sourceforge.sos.lib.image.WritableImage;

/**
 * @author Gaku Tanaka
 */
public abstract class AbstractResultImage extends WritableImage {

	private String	name;
	
	private String prefix;

	AbstractResultImage(String arg) {
		name = arg;
	}

	public String toString() {
		return name;
	}

	void createImage(LabeledImage labeledImage) {
		if (isEnabled()) {
			BufferedImage img = fromLabeledImage(labeledImage);
			setImage(img);
		}
	}

	abstract BufferedImage fromLabeledImage(LabeledImage labeledImage);

	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

}
