package jp.sourceforge.sos.cytoq.result.variables;

import java.util.ArrayList;
import java.util.Vector;

import javax.swing.DefaultListModel;

import jp.sourceforge.sos.cytoq.IVariable;
import jp.sourceforge.sos.framework.util.SundaySingleton;

@SundaySingleton
public abstract class VariableMulti implements IVariable{
	protected ArrayList<String> values = new ArrayList<String>();
	private int number;
	
	public String toString(){
		return getClass().getSimpleName().substring(OFFSET);
	}

	public void toHeader(DefaultListModel header) {
		for (int i=0; i<number; i++){
			header.addElement(toString()+(i+1));
		}
	}

	public void toResult(Vector<String> data) {
		setValue();
		for (int i=0; i<values.size(); i++){
			data.add(values.get(i));
		}
	}

	public String getValue(int i) {
		return values.get(i);
	}

	public void setNumber(Integer changed) {
		number = changed;
	}
}
