package jp.sourceforge.sos.cytoq.result;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.ILinkViewWrapper;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.lib.view.ViewHandlePanel;
import java.awt.Dimension;

@SuppressWarnings("serial")
public class ViewTable extends JScrollPane implements ILinkModel, ILinkViewWrapper {

	private JTable jTable = null;
	
	public String toString(){
		return "RESULT TABLE";
	}

	public void setModel(IComponent model) {
		TableModel tableModel = ((ModelResult)model).getTableModel();
		jTable.setModel(tableModel);	
	}

	public JComponent getWrapper() {
		return new ViewHandlePanel(this);
	}

	public String getContainer() {
		return "jPanelAdd";
	}

	public Object getConstraints() {
		return NO_CONSTRAINT;
	}

	/**
	 * This is the default constructor
	 */
	public ViewTable() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
        this.setPreferredSize(new Dimension(453, 100));
        this.setViewportView(getJTable());
	}

	/**
	 * This method initializes jTable	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJTable() {
		if (jTable==null) {
			jTable = new JTable();
		}
		return jTable;
	}

}
