package jp.sourceforge.sos.cytoq.result;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;

@SuppressWarnings("serial")
public class ViewMenu extends JMenu implements ILinkModel, ILinkContainer{

	private JMenuItem jMenuItemSave = null;
	private JMenuItem jMenuItemClear = null;
	
	private ModelResult modelResult;

	public ViewMenu() {
		super();
		initialize();
		add(getJMenuItemSave());
		add(getJMenuItemClear());
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setText("Result");
        this.add(getJMenuItemSave());
        this.add(getJMenuItemClear());
	}

	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemSave() {
		if (jMenuItemSave==null) {
			jMenuItemSave = new JMenuItem();
			jMenuItemSave.setText("Save...");
			jMenuItemSave.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					modelResult.save();				}
			});
		}
		return jMenuItemSave;
	}

	/**
	 * This method initializes jMenuItem1	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemClear() {
		if (jMenuItemClear==null) {
			jMenuItemClear = new JMenuItem();
			jMenuItemClear.setText("Clear");
			jMenuItemClear.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					modelResult.clear();				}
			});
		}
		return jMenuItemClear;
	}

	public void setModel(IComponent model) {
		modelResult = (ModelResult)model;	
	}

	public String getContainer() {
		return "menuBar";
	}

	public Object getConstraints() {
		return NO_CONSTRAINT;
	}
}
