package jp.sourceforge.sos.cytoq.result;

import javax.swing.JComponent;

import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.ILinkViewWrapper;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.lib.view.ViewMenuItem;
import jp.sourceforge.sos.lib.window.JDoubleListDialog;

@SuppressWarnings("serial")
public class ViewFrame extends JDoubleListDialog implements ILinkModel, ILinkViewWrapper{

	private ModelResult modelResult;
	
	public ViewFrame() {
		super(null, true);
		setTitle(toString());
	}
	
	public String toString(){
		return "Analysis manager";
	}

	public void setModel(IComponent model) {
		modelResult = (ModelResult)model;
		setModel(modelResult.getSelections());
	}

	public JComponent getWrapper() {
		return new ViewMenuItem(this){
			protected void execute() {
				super.execute();
				modelResult.updateHeader();
			}
		};
	}

	public String getContainer() {
		return "jMenuTools";
	}

	public Object getConstraints() {
		return NO_CONSTRAINT;
	}

}
