package jp.sourceforge.sos.cytoq.result;

import java.util.Vector;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import jp.sourceforge.sos.cytoq.IVariable;
import jp.sourceforge.sos.cytoq.colorInit.ModelColorInit;
import jp.sourceforge.sos.cytoq.result.variables.VariableMulti;
import jp.sourceforge.sos.framework.IInitialize;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.io.SOSFileIO;
import jp.sourceforge.sos.lib.window.DoubleListModel;
import jp.sourceforge.sos.lib.window.ListComboBoxModel;

public class ModelResult extends AbstractModel<ModelColorInit> implements IInitialize, IObserver<ColorModel>{
	
	private SOSFileIO fileIO;

	private DefaultTableModel tableModelResult;

	private ListComboBoxModel comboModelHeader;

	private DoubleListModel<IVariable> selections;

	public ModelResult() {
		super();

		fileIO = new SOSFileIO();
		tableModelResult = new DefaultTableModel();
		comboModelHeader = new ListComboBoxModel();
		selections = new DoubleListModel<IVariable>();
	}

	/**
	 * 
	 */
	private void setHeader() {
		comboModelHeader.clear();
		for (int i = 0; i < selections.getSizeSelection(); i++) {
			selections.getSelectionItem(i).toHeader(comboModelHeader);
		}
	}

	public ComboBoxModel getComboModelHeader() {
		setHeader();
		return comboModelHeader;
	}

	public void updateHeader() {
		setHeader();
		tableModelResult.setColumnIdentifiers(comboModelHeader.toArray());
	}

	DoubleListModel getSelections() {
		return selections;
	}

	TableModel getTableModel() {
		return tableModelResult;
	}

	void clear() {
		tableModelResult.setRowCount(0);
	}

	void save() {
		String[] result = new String[tableModelResult.getRowCount()];
		for (int i = 0; i < result.length; i++) {
			StringBuilder builder = new StringBuilder();
			for (int j = 0; j < tableModelResult.getColumnCount(); j++) {
				builder.append(tableModelResult.getValueAt(i, j));
				builder.append(",");
			}
			result[i] = builder.toString();
		}
		fileIO.writeStrings(result);
	}

	@Override
	protected void initModel() {
		modelParent.addObserverInitColor(this);
	}

	public String getDataFromHeader(String name) {
		int column = -1;
		for (int i = 0; i < comboModelHeader.size(); i++) {
			String arg = (String) comboModelHeader.get(i);
			if (arg.equals(name)) {
				column = i;
				break;
			}
		}
		if (column==-1){
			return null;
		}
		int row = tableModelResult.getRowCount() - 1;
		return (String) tableModelResult.getValueAt(row, column);
	}

	public void init() {
		for (int i = 0; i < selections.getSizePreset(); i++) {
			selections.selectFromPreset(i);
		}
		updateHeader();
		
	}

	public DefaultListModel getPresets() {
		return (DefaultListModel)selections.getModelPreset();
	}

	public void addResult() {
		Vector<String> result = new Vector<String>();
		for (int i = 0; i < selections.getSizeSelection(); i++) {
			selections.getSelectionItem(i).toResult(result);
		}
		tableModelResult.addRow(result);
	}

	public void update(ColorModel changed) {
		int n = modelParent.getColorNumber();
		for (int i = 0; i < selections.getSizeSelection(); i++) {
			Object variable = selections.getSelectionItem(i);
			if (variable instanceof VariableMulti) {
				((VariableMulti) variable).setNumber(n);
			}
		}
		updateHeader();
	}

}
