package jp.sourceforge.sos.cytoq.main;

import java.awt.GridLayout;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;

import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.lib.colorspace.SOSColorSpace;

@SuppressWarnings("serial")
class ViewPanelOption extends JPanel implements ILinkModel, ILinkContainer {

	private ModelMain	modelMain			= null;  //  @jve:decl-index=0:

	private JLabel			jLabel					= null;

	private JLabel			jLabel1					= null;

	private JLabel			jLabel2					= null;

	private JSpinner		jSpinnerIteration	= null;

	private JSpinner		jSpinnerEPS				= null;

	private JSpinner		jSpinnerMaxStep	= null;

	private JLabel jLabel3 = null;

	private JSpinner jSpinnerAnimation = null;

	private JLabel jLabel11 = null;

	private JComboBox jComboBox = null;

	ViewPanelOption() {
		super();
		initialize();
	}

	private void initSpinner(JSpinner spinner, int value, int min, int max) {
		SpinnerNumberModel model = new SpinnerNumberModel(min+1, min, max, 1);
		spinner.setModel(model);
		spinner.setValue(value);
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		jLabel11 = new JLabel();
		jLabel11.setText("color space: ");
		jLabel11.setHorizontalAlignment(SwingConstants.RIGHT);
		jLabel3 = new JLabel();
		jLabel3.setHorizontalAlignment(SwingConstants.RIGHT);
		jLabel3.setText("animation step: ");
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Process", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
				javax.swing.border.TitledBorder.DEFAULT_POSITION, null, java.awt.Color.blue));
		GridLayout gridLayout = new GridLayout();
		gridLayout.setColumns(2);
		gridLayout.setRows(5);
		jLabel2 = new JLabel();
		jLabel2.setText("max iteration: ");
		jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		jLabel1 = new JLabel();
		jLabel1.setText("EPS(decimal): ");
		jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		jLabel = new JLabel();
		jLabel.setText("batch iteration: ");
		jLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		this.setLayout(gridLayout);
		this.add(jLabel, null);
		this.add(getJSpinnerIteration(), null);
		this.add(jLabel1, null);
		this.add(getJSpinnerEPS(), null);
		this.add(jLabel2, null);
		this.add(getJSpinnerMaxStep(), null);

		this.add(jLabel3, null);
		this.add(getJSpinnerAnimation(), null);
		this.add(jLabel11, null);
		this.add(getJComboBox(), null);
	}

	/**
	 * This method initializes jSpinner
	 * 
	 * @return javax.swing.JSpinner
	 */
	private JSpinner getJSpinnerIteration() {
		if (jSpinnerIteration==null) {
			jSpinnerIteration = new JSpinner();
			jSpinnerIteration.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					int value = (Integer)jSpinnerIteration.getValue();
					modelMain.setMaxSection(value);
				}
			});
		}
		return jSpinnerIteration;
	}

	/**
	 * This method initializes jSpinner1
	 * 
	 * @return javax.swing.JSpinner
	 */
	private JSpinner getJSpinnerEPS() {
		if (jSpinnerEPS==null) {
			jSpinnerEPS = new JSpinner();
			jSpinnerEPS.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					double value = Math.pow(0.1, (Integer)jSpinnerEPS.getValue());
					modelMain.setEPS(value);
				}
			});
		}
		return jSpinnerEPS;
	}

	/**
	 * This method initializes jSpinner2
	 * 
	 * @return javax.swing.JSpinner
	 */
	private JSpinner getJSpinnerMaxStep() {
		if (jSpinnerMaxStep==null) {
			jSpinnerMaxStep = new JSpinner();
			jSpinnerMaxStep.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					int value = (Integer)jSpinnerMaxStep.getValue();
					modelMain.setMaxStep(value);
				}
			});
		}
		return jSpinnerMaxStep;
	}

	/**
	 * This method initializes jSpinner	
	 * 	
	 * @return javax.swing.JSpinner	
	 */
	private JSpinner getJSpinnerAnimation() {
		if (jSpinnerAnimation==null) {
			jSpinnerAnimation = new JSpinner();
			jSpinnerAnimation.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					int value = (Integer)jSpinnerAnimation.getValue();
					modelMain.setAnimationStep(value);
				}
			});
		}
		return jSpinnerAnimation;
	}

	public void setModel(IComponent model) {
		modelMain = (ModelMain)model;

		initSpinner(jSpinnerIteration, 1, 1, 1000);
		initSpinner(jSpinnerEPS, 7, 0, 16);
		initSpinner(jSpinnerMaxStep, 1000, 1, Integer.MAX_VALUE);
		initSpinner(jSpinnerAnimation, 5, 1, Integer.MAX_VALUE);
		
		jComboBox.addItem(SOSColorSpace.getCIELabSpace());
		jComboBox.addItem(SOSColorSpace.getRGBSpace());
	}

	public String getContainer() {
		return "jPanelOption";
	}

	public Object getConstraints() {
		return new Integer(0);
	}

	/**
	 * This method initializes jComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBox() {
		if (jComboBox==null) {
			jComboBox = new JComboBox();
			jComboBox.setModel(new DefaultComboBoxModel());
			jComboBox.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					setColorSpace();
				}
			});
		}
		return jComboBox;
	}
	
	/**
	 * 
	 */
	private void setColorSpace() {
		SOSColorSpace colorSpace = (SOSColorSpace)jComboBox.getSelectedItem();
		modelMain.setColorSpace(colorSpace);
	}

}
