/**
 * 
 */
package jp.sourceforge.sos.cytoq.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.message.IEndProcess;
import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.loader.PluginClassLoader;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.framework.thread.ThreadStatus;
import jp.sourceforge.sos.framework.util.Factory;
import jp.sourceforge.sos.lib.io.Extension;

/**
 * @author Gaku Tanaka
 * 
 */
@SuppressWarnings("serial")
class ViewPanel extends JPanel implements ILinkModel, ILinkContainer,
		IEndProcess {

	private JComboBox	jComboAlgorithm		= null;

	private JPanel		jPanelOption;

	private ModelMain	modelMain;

	private JPanel		jPanelAlgorithm		= null;

	private JButton		jButton				= null;

	private JComboBox	jComboFileHandler	= null;

	private JPanel		jPanelFile			= null;

	/**
	 * This method initializes
	 * 
	 */
	public ViewPanel() {
		super();
		initialize();
	}

	private void loadPlugin() {
		StringBuffer pathBuffer = new StringBuffer(System
				.getProperty("user.dir"));
		pathBuffer.append(File.separator);
		pathBuffer.append("plugins");
		pathBuffer.append(File.separator);
		pathBuffer.append("segmentation");
		String path = pathBuffer.toString();

		File dir = new File(path);
		PluginClassLoader loader = new PluginClassLoader(path);
		File[] fileList = dir.listFiles();

		if (fileList!=null) {
			for (int i = 0; i<fileList.length; i++) {
				AbstractAlgorithm algorithm = getAlgorithm(loader, fileList[i]
						.getName());
				if (algorithm!=null) {
					jComboAlgorithm.addItem(algorithm);
				}
			}
		}
	}

	/**
	 * @param algorithmName
	 */
	private AbstractAlgorithm getAlgorithm(PluginClassLoader loader,
			String algorithmName) {
		if (algorithmName!=null) {
			algorithmName = Extension.remove(algorithmName);
			try {
				return (AbstractAlgorithm)loader.loadClass(algorithmName)
						.newInstance();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return null;
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		this.setLayout(new BorderLayout());
		this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
		this.add(getJPanelAlgorithm(), BorderLayout.CENTER);
		this.add(getJPanelFile(), BorderLayout.SOUTH);
	}

	/**
	 * This method initializes jComboAlgorithm
	 * 
	 * @return javax.swing.JComboBox
	 */
	private JComboBox getJComboAlgorithm() {
		if (jComboAlgorithm==null) {
			jComboAlgorithm = new JComboBox();
			jComboAlgorithm.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					setAlgorithmOption();
				}
			});
		}
		return jComboAlgorithm;
	}

	private void setAlgorithmOption() {
		AbstractAlgorithm algorithm = (AbstractAlgorithm)jComboAlgorithm
				.getSelectedItem();
		if (algorithm!=null) {
			algorithm.confineFile(jComboFileHandler);
			if (jPanelOption!=null) {
				jPanelAlgorithm.remove(jPanelOption);
			}
			jPanelOption = (JPanel)algorithm.getOptionPanel();
			if (jPanelOption!=null) {
				jPanelAlgorithm.add(jPanelOption, BorderLayout.CENTER);
			}
			jPanelAlgorithm.validate();
			// Window w = SwingUtilities.getWindowAncestor(this);
			// if (w!=null) {
			// w.pack();
			// }
			modelMain.setAlgorithm(algorithm);
		}
	}

	public String getContainer() {
		return "jPanelMain";
	}

	public Object getConstraints() {
		return BorderLayout.WEST;
	}

	public void setModel(IComponent model) {
		modelMain = (ModelMain)model;

		loadPlugin();
		setFileHandler();
		setAlgorithmOption();
	}

	/**
	 * This method initializes jPanelAlgorithm
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelAlgorithm() {
		if (jPanelAlgorithm==null) {
			jPanelAlgorithm = new JPanel();
			jPanelAlgorithm.setLayout(new BorderLayout());
			jPanelAlgorithm.setBorder(BorderFactory.createTitledBorder(null,
					"Algorithm", TitledBorder.DEFAULT_JUSTIFICATION,
					TitledBorder.DEFAULT_POSITION, new Font("Dialog",
							Font.BOLD, 12), Color.blue));
			jPanelAlgorithm.add(getJComboAlgorithm(), BorderLayout.NORTH);
		}
		return jPanelAlgorithm;
	}

	/**
	 * This method initializes jButton
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButton() {
		if (jButton==null) {
			jButton = new JButton();
			jButton.setForeground(new Color(102, 102, 255));
			jButton.setText(ThreadStatus.START.toString());
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					String arg = modelMain.changeProcessStatus(jButton
							.getText());
					jButton.setText(arg);
				}
			});
		}
		return jButton;
	}

	/**
	 * This method initializes jComboFileGetter
	 * 
	 * @return javax.swing.JComboBox
	 */
	private JComboBox getJComboFileHandler() {
		if (jComboFileHandler==null) {
			jComboFileHandler = new JComboBox();
			Factory.set(jComboFileHandler, AbstractFileHandler.class);
			jComboFileHandler.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					setFileHandler();
				}
			});
		}
		return jComboFileHandler;
	}

	/**
	 * 
	 */
	private void setFileHandler() {
		AbstractFileHandler handler = (AbstractFileHandler)jComboFileHandler
				.getSelectedItem();
		if (modelMain!=null) {
			modelMain.setFileHandler(handler);
		}
	}

	public void observeAnalysisFinish(String changed) {
		jButton.setText("START");
	}

	/**
	 * This method initializes jPanelFile
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelFile() {
		if (jPanelFile==null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(2);
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints1.gridwidth = 2;
			gridBagConstraints1.gridx = -1;
			gridBagConstraints1.gridy = -1;
			gridBagConstraints1.insets = new Insets(0, 0, 10, 0);
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints.gridy = -1;
			gridBagConstraints.gridx = -1;
			jPanelFile = new JPanel();
			jPanelFile.setLayout(gridLayout);
			jPanelFile.setBorder(BorderFactory.createTitledBorder(null, "File",
					TitledBorder.DEFAULT_JUSTIFICATION,
					TitledBorder.DEFAULT_POSITION, new Font("Dialog",
							Font.BOLD, 12), Color.blue));
			jPanelFile.add(getJComboFileHandler(), null);
			jPanelFile.add(getJButton(), null);
		}
		return jPanelFile;
	}

}
