/*
 * ViewFrameMain.java
 *
 * Created on 2004/12/05, 18:05
 */

package jp.sourceforge.sos.cytoq.main;

import java.awt.BorderLayout;

import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;

import jp.sourceforge.sos.framework.view.AbstractTopView;
import jp.sourceforge.sos.framework.view.ContainerInAncestor;

/**
 * @author Gaku Tanaka
 */
@SuppressWarnings("serial")
public class ViewFrameMain extends AbstractTopView<ModelMain> {

	@ContainerInAncestor
	private JMenuBar	menuBar					= null;

	private JMenuItem	jMenuItemOption;

	@ContainerInAncestor
	private JMenu		jMenuTools;

	private JSeparator	jSeparator1;

	private JDialog		optionDialog;

	@ContainerInAncestor
	private JPanel		jPanelMain				= null;

	@ContainerInAncestor
	private JPanel		jPanelAdd				= null;

	@ContainerInAncestor
	private JPanel		jPanelOption			= null;

	private JPanel		jContentPane			= null;

	@ContainerInAncestor
	private JPanel		jPanelColor				= null;

	public ViewFrameMain() {
		super();
		initComponents();
	}


	private void initComponents() {
		optionDialog = new javax.swing.JDialog();
		optionDialog.setTitle("Option");
		optionDialog.setSize(new java.awt.Dimension(100,32));
		jMenuTools = new javax.swing.JMenu();
		jSeparator1 = new javax.swing.JSeparator();
		jMenuItemOption = new javax.swing.JMenuItem();

		getContentPane().setLayout(new java.awt.GridBagLayout());

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		this.setJMenuBar(getMainMenuBar());
		setTitle("CytoQ");
		setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));

		jMenuTools.setText("Tools");
		jMenuTools.setName("jMenuTools");
		jMenuTools.add(jMenuItemOption);

		jMenuTools.add(jSeparator1);

		jMenuItemOption.setText("Option");
		jMenuItemOption.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jMenuItemOptionActionPerformed(evt);
			}
		});

		menuBar.add(jMenuTools);

		this.setContentPane(getJContentPane());
		this.addComponentListener(new java.awt.event.ComponentAdapter() {
			public void componentResized(java.awt.event.ComponentEvent e) {
				model.resized(getBounds());
			}
		});
		optionDialog.setContentPane(getJPanelOption());
		pack();
	}

	private void jMenuItemOptionActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jMenuItemOptionActionPerformed
		optionDialog.setVisible(true);
	}

	/**
	 * This method initializes jPanelMain
	 * 
	 * @return javax.swing.JPanel
	 */
	JPanel getJPanelMain() {
		if (jPanelMain==null) {
			jPanelMain = new JPanel();
			jPanelMain.setLayout(new BorderLayout());
			jPanelMain.add(getJPanelColor(), BorderLayout.CENTER);
		}
		return jPanelMain;
	}

	/**
	 * This method initializes jPanelAdd
	 * 
	 * @return javax.swing.JPanel
	 */
	JPanel getJPanelAdd() {
		if (jPanelAdd==null) {
			jPanelAdd = new JPanel();
			jPanelAdd.setLayout(new BoxLayout(getJPanelAdd(), BoxLayout.Y_AXIS));
		}
		return jPanelAdd;
	}

	/**
	 * This method initializes jContentPane1
	 * 
	 * @return javax.swing.JPanel
	 */
	JPanel getJPanelOption() {
		if (jPanelOption==null) {
			jPanelOption = new JPanel();
			jPanelOption.setLayout(new BoxLayout(getJPanelOption(), BoxLayout.Y_AXIS));
		}
		return jPanelOption;
	}

	/**
	 * This method initializes jJMenuBar
	 * 
	 * @return javax.swing.JMenuBar
	 */
	private JMenuBar getMainMenuBar() {
		if (menuBar==null) {
			menuBar = new JMenuBar();
		}
		return menuBar;
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	protected JPanel getJContentPane() {
		if (jContentPane==null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getJPanelMain(), BorderLayout.NORTH);
			jContentPane.add(getJPanelAdd(), BorderLayout.CENTER);
		}
		return jContentPane;
	}

	@Override
	protected void initView() {

	}

	/**
	 * This method initializes jPanel
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelColor() {
		if (jPanelColor==null) {
			jPanelColor = new JPanel();
			jPanelColor.setLayout(new BorderLayout());
			jPanelColor.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Color", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
		}
		return jPanelColor;
	}
	
	public void init(){
		super.init();
		optionDialog.pack();
	}
}
