package jp.sourceforge.sos.cytoq.main;

import java.awt.Rectangle;

import jp.sourceforge.sos.cytoq.message.IAnimation;
import jp.sourceforge.sos.cytoq.message.IEndProcess;
import jp.sourceforge.sos.cytoq.message.IEndSection;
import jp.sourceforge.sos.cytoq.message.IInitProcess;
import jp.sourceforge.sos.cytoq.message.IInitSection;
import jp.sourceforge.sos.cytoq.message.IResize;

public class ModelMainObservable extends ModelMain {

	@Override
	protected void initProcess() {
		super.initProcess();
		bus.inform(IInitProcess.class, fileHandler);
	}
	
	@Override
	protected void initSection() {
		super.initSection();
		bus.inform(IInitSection.class, algorithm);
	}
	
	@Override
	public void endAnimationStep() {
		super.endAnimationStep();
		bus.inform(IAnimation.class, algorithm);
	}
	
	@Override
	protected void endSection() {
		super.endSection();
		bus.inform(IEndSection.class, algorithm);
	}
	
	@Override
	public void endProcess() {
		super.endProcess();
		bus.inform(IEndProcess.class, "");
	}
	
	public void resized(Rectangle changed) {
		bus.inform(IResize.class,changed);
	}
}
