package jp.sourceforge.sos.cytoq.main;

import java.awt.Rectangle;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.framework.thread.AbstractThread;
import jp.sourceforge.sos.lib.colorspace.SOSColorSpace;

public class ModelMain extends AbstractThread {

	private double eps;

	AbstractAlgorithm algorithm;

	AbstractFileHandler fileHandler;
	
	private SOSColorSpace colorSpace;

	ModelMain() {
		super();
	}

	public void setAlgorithm(AbstractAlgorithm plugin) {
		algorithm = plugin;
	}

	@SuppressWarnings("unchecked")
	@Override
	protected void initProcess() {
		super.initProcess();
		setMaxSection(fileHandler.setFiles());

		algorithm.setFileHandler(fileHandler);
		ready = algorithm.initProcess();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected void initSection() {
		algorithm.initSection();
		createInput();
		algorithm.setDesiredValue(eps);
		
		super.initSection();
	}

	private void createInput() {
		int[] intRGB = algorithm.getIntColors();
		double[][] input = new double[intRGB.length][];
		int[] rgb = new int[3];
		for (int i = 0; i<intRGB.length; i++) {
			rgb[0] = (intRGB[i]>>16)&0xFF;
			rgb[1] = (intRGB[i]>>8)&0xFF;
			rgb[2] = (intRGB[i]>>0)&0xFF;
			input[i] = colorSpace.fromRGB(rgb);
		}
		algorithm.setInput(input);
	}

	@Override
	protected void mainLoop() {
		algorithm.calculate();
	}

	@Override
	protected void endAnimationStep() {
		int[] label = algorithm.getCluster();
		if (label != null) {
			algorithm.getLabeledImage().setLabels(label);
		}
	}
	
	protected void endSection(){
		super.endSection();
		algorithm.getImageColor().setLabels(algorithm.getCluster());
	}
	
	public void endProcess(){
		algorithm.endProcess();
	}

	@Override
	protected boolean isConvoluted() {
		return algorithm.isConvoluted();
	}

	void setFileHandler(AbstractFileHandler handler) {
		this.fileHandler = handler;
	}

	@Override
	protected void initModel() {
	}

	public void setEPS(double value) {
		eps = value;
	}

	public void resized(Rectangle bounds) {
	}

	public int[] getColorLabel() {
		return algorithm.getCluster();
	}

	public void setInput(double[][] input) {
		algorithm.setInput(input);
	}

	public AbstractAlgorithm getAlgorithm() {
		return algorithm;
	}

	public int[] getLabelCount() {
		return algorithm.getLabeledImage().getLabelCount();
	}
	
	public void setColorSpace(SOSColorSpace colorSpace){
		this.colorSpace = colorSpace;
	}

	public SOSColorSpace getColorSpace() {
		return colorSpace;
	}
}
