/*
 * ProcessBatch.java
 *
 * Created on 2005/06/12, 0:45
 *
 */

package jp.sourceforge.sos.cytoq.main;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.window.JProgressDialog;

/**
 * @author Gaku Tanaka
 */
class FileBatch extends AbstractFileHandler {

	private File			dirSave;

	private Iterator<File>	iterator;

	private int				fileNumber;

	private File	dirOpen;

	@Override
	public int setFiles() {
		dirOpen = imageIO.getOpenDirectory();
		if (dirOpen==null) {
			return 0;
		}
		dirSave = imageIO.getSaveDirectory();
		if (dirSave==null) {
			return 0;
		}
		extractFiles(dirOpen.listFiles());
		return fileNumber;
	}

	/**
	 * 
	 */
	protected void extractFiles(File[] files) {
		Arrays.sort(files);
		ArrayList<File> filesList = new ArrayList<File>();

		JProgressDialog dialog = new JProgressDialog(null);
		dialog.start("Loading images...", false);
		for (int i = 0; i<files.length; i++) {
			Image img = SOSImageIO.readImage(files[i]);
			if (img!=null) {
				filesList.add(files[i]);
			}
			dialog.setValue(100*i/files.length);
		}
		dialog.stop();

		iterator = filesList.iterator();
		fileNumber = filesList.size();
	}

	public int getOrder() {
		return 1;
	}

	@Override
	public void next() {
		currentFile = iterator.next();
	}

	@Override
	public String getPath() {
		StringBuilder builder = new StringBuilder();
		builder.append(dirSave);
		builder.append(File.separator);
		return builder.toString();
	}

	@Override
	public File getDir() {
		return dirOpen;
	}

}
