package jp.sourceforge.sos.cytoq.main;

import java.io.File;

import jp.sourceforge.sos.framework.container.IOrder;
import jp.sourceforge.sos.lib.io.SOSImageIO;

public abstract class AbstractFileHandler implements IOrder {

	static protected final int	SINGLE_FILE_NUMBER	= 1;

	static protected SOSImageIO	imageIO;

	static {
		imageIO = SOSImageIO.getInstance();
	}

	protected File				currentFile;

	@Override
	public String toString() {
		return getClass().getSimpleName().substring(4);
	}

	abstract public int setFiles();

	public File getCurrentFile() {
		return currentFile;
	}

	abstract public void next();

	abstract public String getPath();

	abstract public File getDir();

}
