package jp.sourceforge.sos.cytoq.equation;

import java.awt.BorderLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.message.IEndSection;
import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.framework.pattern.IObserver;

@SuppressWarnings("serial")
public class ViewPanel extends JPanel implements ILinkModel, IEndSection, IObserver<String>, ILinkContainer{
	
	private JLabel jLabelEquation = null;
	private JLabel jLabel = null;
	private JLabel jLabelValue = null;
	private ModelEquation	modelEquation;

	/**
	 * This is the default constructor
	 */
	public ViewPanel() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		jLabelValue = new JLabel();
		jLabelValue.setText(" ");
		jLabelValue.setPreferredSize(new java.awt.Dimension(100,16));
		jLabel = new JLabel();
		jLabel.setText("=");
		jLabelEquation = new JLabel();
		jLabelEquation.setText("JLabel");
		jLabelEquation.setForeground(java.awt.Color.gray);
		this.setLayout(new BorderLayout());
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Result", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
		this.add(jLabelEquation, java.awt.BorderLayout.NORTH);
		this.add(jLabel, java.awt.BorderLayout.WEST);
		this.add(jLabelValue, java.awt.BorderLayout.CENTER);
	}

	public String getContainer() {
		return "jPanelAdd";
	}

	public Object getConstraints() {
		return new Integer(0);
	}

	public void setModel(IComponent model) {
		modelEquation = (ModelEquation)model;
		modelEquation.addObserver(this);
	}

	public void observeEndSection(AbstractAlgorithm changed) {
		String result = modelEquation.calcEquation();
		jLabelValue.setText(result);
	}

	public void update(String changed) {
		jLabelEquation.setText(changed);
	}

}
