/*
 * JDialogAlgebla.java
 *
 * Created on 2005/04/24, 13:18
 */

package jp.sourceforge.sos.cytoq.equation;

import javax.swing.JComponent;
import javax.swing.JDialog;

import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.ILinkViewWrapper;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.lib.view.ViewMenuItem;

/**
 * @author Gaku Tanaka
 */
@SuppressWarnings("serial")
class ViewFrame extends JDialog implements ILinkModel, ILinkViewWrapper, IObserver<String> {
	
	static private final Integer	DEFAULT_DECIMAL	= new Integer(2);

	private ModelEquation	modelEquation;

	private String			backupEquation;

	private String			backupUnit;

	private Integer			backupDecimal;

	/** Creates new form JDialogAlgebla */
	protected ViewFrame() {
		initComponents();
		jSpinnerDecimal.setValue(DEFAULT_DECIMAL);
	}
	
	public String toString() {
		return "Equation Manager";
	}

	public void setModel(IComponent model) {
		modelEquation = (ModelEquation)model;
		jComboVariable.setModel(modelEquation.getHeader());
		modelEquation.addObserver(this);
	}

	public JComponent getWrapper() {
		return new ViewMenuItem(this);
	}

	public String getContainer() {
		return "jMenuTools";
	}

	public Object getConstraints() {
		return NO_CONSTRAINT;
	}
	
	private void initComponents() {
		java.awt.GridBagConstraints gridBagConstraints;

		jButtonAlgeblaOK = new javax.swing.JButton();
		jButtonAlgeblaCancel = new javax.swing.JButton();
		jPanelEditor = new javax.swing.JPanel();
		jComboVariable = new javax.swing.JComboBox();
		jButtonVariable = new javax.swing.JButton();
		jLabel4 = new javax.swing.JLabel();
		jLabel5 = new javax.swing.JLabel();
		jPanelOperator = new javax.swing.JPanel();
		jButtonPlus = new javax.swing.JButton();
		jButtonMinus = new javax.swing.JButton();
		jButtonMultiple = new javax.swing.JButton();
		jButtonDivide = new javax.swing.JButton();
		jButtonLeftParenthesis = new javax.swing.JButton();
		jButtonRightParenthesis = new javax.swing.JButton();
		jLabel6 = new javax.swing.JLabel();
		jButtonConstant = new javax.swing.JButton();
		jLabel1 = new javax.swing.JLabel();
		jLabelEquation = new javax.swing.JLabel();
		jTextConstant = new javax.swing.JTextField();
		jPanel1 = new javax.swing.JPanel();
		jButtonBackspace = new javax.swing.JButton();
		jButtonClear = new javax.swing.JButton();
		jPanelDisplay = new javax.swing.JPanel();
		jLabel2 = new javax.swing.JLabel();
		jTextUnit = new javax.swing.JTextField();
		jLabel3 = new javax.swing.JLabel();
		jSpinnerDecimal = new javax.swing.JSpinner();

		getContentPane().setLayout(new java.awt.GridBagLayout());

		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		setTitle("Equation Manager");
		addComponentListener(new java.awt.event.ComponentAdapter() {
			public void componentShown(java.awt.event.ComponentEvent evt) {
				backupEquation = jLabelEquation.getText();
				backupUnit = jTextUnit.getText();
				backupDecimal = (Integer)jSpinnerDecimal.getValue();
			}
		});

		jButtonAlgeblaOK.setText("OK");
		jButtonAlgeblaOK.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				setVisible(false);
			}
		});

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
		getContentPane().add(jButtonAlgeblaOK, gridBagConstraints);

		jButtonAlgeblaCancel.setText("CANCEL");
		jButtonAlgeblaCancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				jLabelEquation.setText(backupEquation);
				jTextUnit.setText(backupUnit);
				jSpinnerDecimal.setValue(backupDecimal);
				setVisible(false);
			}
		});

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		getContentPane().add(jButtonAlgeblaCancel, gridBagConstraints);

		jPanelEditor.setLayout(new java.awt.GridBagLayout());

		jPanelEditor.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Editor", javax.swing.border.TitledBorder.LEADING, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
		jComboVariable.setPreferredSize(new java.awt.Dimension(150, 24));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 5;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanelEditor.add(jComboVariable, gridBagConstraints);

		jButtonVariable.setText("ADD");
		jButtonVariable.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				modelEquation.appendVariable((String) jComboVariable.getSelectedItem());
			}
		});

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 5;
		jPanelEditor.add(jButtonVariable, gridBagConstraints);

		jLabel4.setForeground(java.awt.Color.gray);
		jLabel4.setText("variable: ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 5;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		jPanelEditor.add(jLabel4, gridBagConstraints);

		jLabel5.setForeground(java.awt.Color.gray);
		jLabel5.setText("operator: ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.gridwidth = 3;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanelEditor.add(jLabel5, gridBagConstraints);

		jButtonPlus.setText("+");
		jButtonPlus.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				modelEquation.appendNonVariable("+");
			}
		});

		jPanelOperator.add(jButtonPlus);

		jButtonMinus.setText("-");
		jButtonMinus.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				modelEquation.appendNonVariable("-");
			}
		});

		jPanelOperator.add(jButtonMinus);

		jButtonMultiple.setText("*");
		jButtonMultiple.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				modelEquation.appendNonVariable("*");
			}
		});

		jPanelOperator.add(jButtonMultiple);

		jButtonDivide.setText("/");
		jButtonDivide.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				modelEquation.appendNonVariable("/");
			}
		});

		jPanelOperator.add(jButtonDivide);

		jButtonLeftParenthesis.setText("(");
		jButtonLeftParenthesis.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				modelEquation.appendNonVariable("(");
			}
		});

		jPanelOperator.add(jButtonLeftParenthesis);

		jButtonRightParenthesis.setText(")");
		jButtonRightParenthesis.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				modelEquation.appendNonVariable(")");
			}
		});

		jPanelOperator.add(jButtonRightParenthesis);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.gridwidth = 3;
		jPanelEditor.add(jPanelOperator, gridBagConstraints);

		jLabel6.setForeground(java.awt.Color.gray);
		jLabel6.setText("constant: ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		jPanelEditor.add(jLabel6, gridBagConstraints);

		jButtonConstant.setText("ADD");
		jButtonConstant.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				modelEquation.appendNonVariable(jTextConstant.getText());
			}
		});

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 4;
		jPanelEditor.add(jButtonConstant, gridBagConstraints);

		jLabel1.setForeground(java.awt.Color.gray);
		jLabel1.setText("equation:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 3;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanelEditor.add(jLabel1, gridBagConstraints);

		jLabelEquation.setText(" ");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridwidth = 3;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		jPanelEditor.add(jLabelEquation, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		jPanelEditor.add(jTextConstant, gridBagConstraints);

		jButtonBackspace.setText("BACK SPACE");
		jButtonBackspace.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				modelEquation.remove();
			}
		});

		jPanel1.add(jButtonBackspace);

		jButtonClear.setText("CLEAR");
		jButtonClear.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				modelEquation.clearObserver();
			}
		});

		jPanel1.add(jButtonClear);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 6;
		gridBagConstraints.gridwidth = 3;
		jPanelEditor.add(jPanel1, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
		getContentPane().add(jPanelEditor, gridBagConstraints);

		jPanelDisplay.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Display", javax.swing.border.TitledBorder.LEADING, javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
		jLabel2.setForeground(java.awt.Color.gray);
		jLabel2.setText("unit: ");
		jPanelDisplay.add(jLabel2);

		jTextUnit.setText("%");
		jTextUnit.setMinimumSize(new java.awt.Dimension(50, 22));
		jTextUnit.setPreferredSize(new java.awt.Dimension(50, 22));
		jPanelDisplay.add(jTextUnit);

		jLabel3.setForeground(java.awt.Color.gray);
		jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		jLabel3.setText("decimal place: ");
		jLabel3.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
		jPanelDisplay.add(jLabel3);

		jSpinnerDecimal.setPreferredSize(new java.awt.Dimension(50, 20));
		jPanelDisplay.add(jSpinnerDecimal);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridheight = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
		getContentPane().add(jPanelDisplay, gridBagConstraints);

		pack();
	}


	private javax.swing.JButton		jButtonAlgeblaCancel;

	private javax.swing.JButton		jButtonAlgeblaOK;

	private javax.swing.JButton		jButtonBackspace;

	private javax.swing.JButton		jButtonClear;

	private javax.swing.JButton		jButtonConstant;

	private javax.swing.JButton		jButtonDivide;

	private javax.swing.JButton		jButtonLeftParenthesis;

	private javax.swing.JButton		jButtonMinus;

	private javax.swing.JButton		jButtonMultiple;

	private javax.swing.JButton		jButtonPlus;

	private javax.swing.JButton		jButtonRightParenthesis;

	private javax.swing.JButton		jButtonVariable;

	private javax.swing.JComboBox	jComboVariable;

	private javax.swing.JLabel		jLabel1;

	private javax.swing.JLabel		jLabel2;

	private javax.swing.JLabel		jLabel3;

	private javax.swing.JLabel		jLabel4;

	private javax.swing.JLabel		jLabel5;

	private javax.swing.JLabel		jLabel6;

	private javax.swing.JLabel		jLabelEquation;

	private javax.swing.JPanel		jPanel1;

	private javax.swing.JPanel		jPanelDisplay;

	private javax.swing.JPanel		jPanelEditor;

	private javax.swing.JPanel		jPanelOperator;

	private javax.swing.JSpinner	jSpinnerDecimal;

	private javax.swing.JTextField	jTextConstant;

	private javax.swing.JTextField	jTextUnit;

	public void update(String changed) {
		if (changed.startsWith("=")){
			jLabelEquation.setText(changed);
		}
	}

}
