package jp.sourceforge.sos.cytoq.equation;

import java.text.DecimalFormat;
import java.util.ArrayList;

import javax.swing.ComboBoxModel;

import jp.sourceforge.sos.cytoq.result.ModelResult;
import jp.sourceforge.sos.framework.IInitialize;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.pattern.IObservable;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.framework.pattern.ObserverSet;
import jp.sourceforge.sos.lib.math.RevertPolish;

@SuppressWarnings("unchecked")
public class ModelEquation extends AbstractModel<ModelResult> implements IInitialize, IObservable<String>{

	private ArrayList<String>	equationItems	= new ArrayList<String>();

	private DecimalFormat		format;
	
	private ObserverSet<String> observers = new ObserverSet<String>();
	
	public ModelEquation(){
		format	= new DecimalFormat();
		format.setMaximumFractionDigits(2);
		format.setMultiplier(100);
		format.setPositiveSuffix("%");
	}

	@Override
	protected void initModel() {}
	
	public void init() {
		equationItems.add("@Area3");
		equationItems.add("/");
		equationItems.add("(");
		equationItems.add("@Area2");
		equationItems.add("+");
		equationItems.add("@Area3");
		equationItems.add(")");
		setEquation();
	}

	private void setEquation() {
		StringBuffer buffer = new StringBuffer("=");
		if (0<equationItems.size()) {
			for (int i = 0; i<equationItems.size(); i++) {
				String item = equationItems.get(i);
				if (item.startsWith("@")) {
					item = item.substring(1);
				}
				buffer.append(item);
			}
		}
		String result = buffer.toString();
		observers.notify(result);
	}

	void remove() {
		int index = equationItems.size()-1;
		if (0<=index) {
			equationItems.remove(index);
			setEquation();
		}
	}

	void clear() {
		equationItems.clear();
		setEquation();
	}

	void appendVariable(String item) {
		equationItems.add("@"+item);
		setEquation();
	}

	void appendNonVariable(String arg) {
		equationItems.add(arg);
		setEquation();
	}

	ComboBoxModel getHeader() {
		return modelParent.getComboModelHeader();
	}

	String calcEquation() {
		modelParent.addResult();
		StringBuilder equation = new StringBuilder();
		for (int i = 0; i<equationItems.size(); i++) {
			String item = equationItems.get(i);
			if (item.startsWith("@")) {
				item = getVaribale(item.substring(1));
			}
			equation.append(item);
		}

		String arg = equation.toString();
		if (arg==null || arg.length()==0){
			return "";
		}
		return format.format(RevertPolish.calc(arg));
	}

	private String getVaribale(String name) {
		return modelParent.getDataFromHeader(name);
	}

	public void addObserver(IObserver<String> observer) {
		observers.addObserver(observer);
	}

	public void removeObserver(IObserver<String> observer) {
		observers.removeObserver(observer);	
	}

	public void clearObserver() {
		observers.clearObserver();
	}
	
}
