package jp.sourceforge.sos.cytoq.colorView;

import javax.swing.JPanel;

import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.lib.panel.JHandlePanel;
import java.awt.GridLayout;

public class ViewPanel extends JPanel implements ILinkModel, ILinkContainer {

	/**
	 * 
	 */
	private static final long	serialVersionUID	= -1937047131279382346L;

	private JHandlePanel		jHandleDistribution	= null;

	private JHandlePanel		jHandleSegmentation	= null;

	/**
	 * This method initializes
	 * 
	 */
	public ViewPanel() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		GridLayout gridLayout = new GridLayout();
		gridLayout.setRows(1);
		this.setLayout(gridLayout);
		this.add(getJHandleDistribution(), null);
		this.add(getJHandleSegmentation(), null);
	}

	/**
	 * This method initializes jHandleDistribution
	 * 
	 * @return jp.sourceforge.sos.lib.panel.JHandlePanel
	 */
	private JHandlePanel getJHandleDistribution() {
		if (jHandleDistribution==null) {
			jHandleDistribution = new JHandlePanel();
		}
		return jHandleDistribution;
	}

	/**
	 * This method initializes jHandleSegmentation
	 * 
	 * @return jp.sourceforge.sos.lib.panel.JHandlePanel
	 */
	private JHandlePanel getJHandleSegmentation() {
		if (jHandleSegmentation==null) {
			jHandleSegmentation = new JHandlePanel();
		}
		return jHandleSegmentation;
	}

	public void setModel(IComponent model) {
		ModelColorView modelColorView = (ModelColorView)model;
		jHandleDistribution.setMainComponent(modelColorView.getCanvases(0));
		jHandleSegmentation.setMainComponent(modelColorView.getCanvases(1));
		
		jHandleDistribution.setExpanded(true);
		jHandleSegmentation.setExpanded(true);
	}
	
	public String getContainer() {
		return "jPanelAdd";
	}

	public Object getConstraints() {
		return NO_CONSTRAINT;
	}
}
