/**
 * 
 */
package jp.sourceforge.sos.cytoq.colorView;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.AnimationImage;

/**
 * @author Scientific Open Source Project (Gaku Tanaka)
 * 
 */
@SuppressWarnings("serial")
class CanvasSegmentation extends AbstractCanvas {

	private AnimationImage	animation	= new AnimationImage();

	private int[]			segmentedColors;

	@Override
	public void observeAnimation(AbstractAlgorithm changed) {
		if (!isVisible()) {
			return;
		}

		int[] labels = changed.getCluster();
		modelColorView.createColors(segmentedColors, labels);
		modelColorView.setPointColor(segmentedColors);
		modelColorView.updatePixels(animation.getWidth(),
				animation.getHeight(), animation.getPixels());
		animation.update();
		canvas.repaint();
	}

	@Override
	public void observeInitSection(AbstractAlgorithm changed) {
		initFrame();
		int n = changed.getIntColors().length;
		segmentedColors = new int[n];
		animation.setSize(canvas.getWidth(), canvas.getHeight());
		canvasBackground.setImage(createImage(animation.getImageProducer()));
		canvasBackground.getImageTransform().setFullSrc();
		canvasBackground.repaint();
	}
}
