/**
 * 
 */
package jp.sourceforge.sos.cytoq.colorView;

import java.awt.Color;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.graphics.shape.GraphicsPointRect;

/**
 * @author Scientific Open Source Project (Gaku Tanaka)
 * 
 */
@SuppressWarnings("serial")
class CanvasDistribution extends AbstractCanvas implements IObserver<ColorModel>{
	
	private void addRect() {
		GraphicsPointRect pr = new GraphicsPointRect(0, 0, 10);
		pr.setDrawBounds(true);
		pr.setFillRect(true);
		pr.setBoundsColor(Color.black);
		canvas.addGraphicObject(pr);
	}

	private void removeRect() {
		canvas.removeGraphicObject(canvas.getObjectsSize()-1);
	}

	@Override
	public void observeAnimation(AbstractAlgorithm changed){
		if (!isVisible()){
			return;
		}
		
		ColoredVector v = modelColorView.getUnitRects();
		int[] color = v.getColor();
		for (int i = 0; i<color.length; i++) {
			
			GraphicsPointRect pr = (GraphicsPointRect)canvas
					.getGraphicObject(i);
			
			int[] p = modelColorView.convertRect(i);
			pr.setLocation(p[0], p[1]);
			
			pr.setRectColor(new Color(color[i]));
		}
		canvas.repaint();
	}

	@Override
	public void observeInitSection(AbstractAlgorithm changed) {
		initFrame();
	}

	public void update(ColorModel changed) {
		int n = modelColorView.getColorNumber()-canvas.getObjectsSize();
		if (0<=n) {
			for (int i = 0; i<n; i++) {
				addRect();
			}
		} else {
			for (int i = 0; i<-n; i++) {
				removeRect();
			}
		}
	}

}
