package jp.sourceforge.sos.cytoq.colorView;

import java.awt.Dimension;
import java.awt.Window;

import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.lib.canvas.JImageCanvas;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;

/**
 * @author Gaku Tanaka
 */
abstract class AbstractCanvas extends JLayeredPane implements ILinkModel{

	ModelColorView			modelColorView;

	JObjectCanvas			canvas				= null;

	JImageCanvas			canvasBackground	= null;

	/** Creates new form AbstractView */
	public AbstractCanvas() {
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.add(getCanvas(), null);
        this.add(getCanvasBackground(), null);
	}

	public String toString() {
		return getClass().getSimpleName().substring(6).toUpperCase();
	}

	public void setModel(IComponent model) {
		modelColorView = (ModelColorView)model;
		setVisible(true);
	}

	protected void initFrame() {
		int w = getWidth();
		int h = modelColorView.getHeight(w);

		canvasBackground.setSize(w, h);
		canvasBackground.setImage(modelColorView.getImage(w, h));
		canvasBackground.getImageTransform().setFullSrc();
		canvas.setSize(w, h);
		
		setPreferredSize(new Dimension(w, h));
		Window window = SwingUtilities.getWindowAncestor(this);
		window.pack();
	}

	/**
	 * This method initializes jImageCanvas
	 * 
	 * @return jp.sourceforge.sos.lib.canvas.JImageCanvas
	 */
	private JObjectCanvas getCanvas() {
		if (canvas==null) {
			canvas = new JObjectCanvas();
			canvas.setOpaque(false);
		}
		return canvas;
	}

	/**
	 * This method initializes jImageCanvas
	 * 
	 * @return jp.sourceforge.sos.lib.canvas.JImageCanvas
	 */
	private JImageCanvas getCanvasBackground() {
		if (canvasBackground==null) {
			canvasBackground = new JImageCanvas();
		}
		return canvasBackground;
	}

	abstract public void observeAnimation(AbstractAlgorithm changed);

	abstract public void observeInitSection(AbstractAlgorithm changed);
} 
