package jp.sourceforge.sos.cytoq.colorInit;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;

import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.framework.util.SundaySingleton;
import jp.sourceforge.sos.framework.view.ContainerInAncestor;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.color.JPanelColor;

@SundaySingleton
@SuppressWarnings("serial")
public class ViewPanel extends JPanel implements ILinkModel, ILinkContainer, IObserver<ColorModel>{

	private ModelColorInit	modelColor;

	private JLabel		jLabel		= null;

	private JSpinner	jSpinner	= null;

	@ContainerInAncestor
	private JPanel jPanelColorModels = null;

	private JPanel jPanelInit = null;

	private JPanelColor jColorPanel = null;

	private JLabel jLabel2 = null;

	private JComboBox jComboPickup = null;

	private JPanel jPanel = null;

	/**
	 * This method initializes
	 * 
	 */
	public ViewPanel() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
		gridBagConstraints4.gridx = 0;
		gridBagConstraints4.gridwidth = 4;
		gridBagConstraints4.gridy = 1;
		this.setLayout(new GridBagLayout());
		this.add(getJPanelColorModels(), gridBagConstraints4);
		this.add(getJPanel(), new GridBagConstraints());
	}

	/**
	 * This method initializes jLabel
	 * 
	 * @return javax.swing.JLabel
	 */
	private JLabel getJLabel() {
		if (jLabel==null) {
			jLabel = new JLabel();
			jLabel.setText("number:  ");
			jLabel.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel.setForeground(java.awt.Color.gray);
		}
		return jLabel;
	}
	
	private JLabel getJLabel2() {
		if (jLabel2==null) {
			jLabel2 = new JLabel();
			jLabel2.setText("source:  ");
			jLabel2.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel2.setForeground(java.awt.Color.gray);
		}
		return jLabel2;
	}

	/**
	 * This method initializes jSpinner
	 * 
	 * @return javax.swing.JSpinner
	 */
	private JSpinner getJSpinner() {
		if (jSpinner==null) {
			jSpinner = new JSpinner();
			jSpinner.setPreferredSize(new java.awt.Dimension(50,20));
			jSpinner.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
			jSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					int n = (Integer)jSpinner.getValue();
					modelColor.updateColorNumber(n);
				}
			});
		}
		return jSpinner;
	}

	public String getContainer() {
		return "jPanelColor";
	}

	public Object getConstraints() {
		return BorderLayout.NORTH;
	}

	public void setModel(IComponent model) {
		modelColor = (ModelColorInit)model;
		
		jColorPanel.setModel(modelColor.getColorModel());
		jColorPanel.setLabelBase("#");
		((JPanelColor) jColorPanel).setChoosable(true);

		jComboPickup.setModel(modelColor.getPickups());
		
		modelColor.addObserverInitColor(this);
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelColorModels() {
		if (jPanelColorModels==null) {
			jPanelColorModels = new JPanel();
			jPanelColorModels.setLayout(new BorderLayout());
			jPanelColorModels.add(getJPanelInit(), BorderLayout.WEST);
		}
		return jPanelColorModels;
	}

	/**
	 * This method initializes jPanelInit	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelInit() {
		if (jPanelInit==null) {
			jPanelInit = new JPanel();
			jPanelInit.setLayout(new BorderLayout());
			jPanelInit.setBorder(BorderFactory.createTitledBorder(null, "Initial", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), java.awt.Color.blue));
			jPanelInit.add(getJColorPanel(), BorderLayout.CENTER);
		}
		return jPanelInit;
	}

	/**
	 * This method initializes jColorPanel	
	 * 	
	 * @return jp.sourceforge.sos.lib.color.JPanelColor	
	 */
	private JPanelColor getJColorPanel() {
		if (jColorPanel==null) {
			jColorPanel = new JPanelColor();
		}
		return jColorPanel;
	}

	/**
	 * This method initializes jComboPickup	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboPickup() {
		if (jComboPickup==null) {
			jComboPickup = new JComboBox();
		}
		return jComboPickup;
	}

	public void update(ColorModel changed) {
		int n = modelColor.getColorNumber();
		jSpinner.setValue(n);
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel==null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(1);
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.gridx = -1;
			gridBagConstraints2.gridy = -1;
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.insets = new Insets(0, 10, 0, 0);
			gridBagConstraints3.gridy = -1;
			gridBagConstraints3.gridx = -1;
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.gridx = -1;
			gridBagConstraints1.gridy = -1;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.insets = new Insets(0, 10, 0, 0);
			gridBagConstraints.gridy = -1;
			gridBagConstraints.gridx = -1;
			jPanel = new JPanel();
			jPanel.setLayout(gridLayout);
			jPanel.add(getJLabel(), null);
			jPanel.add(getJSpinner(), null);
			jPanel.add(getJLabel2(), null);
			jPanel.add(getJComboPickup(), null);
		}
		return jPanel;
	}
	

}
