package jp.sourceforge.sos.cytoq.colorInit;

class PresetData {
	static private final String SEPARATOR = "&&";
	private int[] data;
	private String name;
	
	PresetData(){
	}
	
	PresetData(String name, int[] data) {
		this.name = name;
		this.data = data;
	}

	public String toString(){
		return name;
	}
	
	void setName(String arg){
		name = arg;
	}

	int[] getData() {
		return data;
	}	
	
	void setData(int[] datum) {
		data = datum;
	}	

	void set(String arg){
		String[] elements = arg.split(SEPARATOR);
		setName(elements[0]);
		
		data = new int[elements.length-1];
		for (int i=1; i<elements.length; i++){
			data[i-1] = Integer.parseInt(elements[i]);
		}
	}
	
	String getSaveString(){
		StringBuilder builder = new StringBuilder();
		builder.append(name);
		for (int i=0; i<data.length; i++){
			builder.append(SEPARATOR+data[i]);
		}
		return builder.toString();
	}
}
