package jp.sourceforge.sos.cytoq.colorInit;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.IPickup;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;

/**
 * @author   Gaku Tanaka
 */
class PickupRandom implements IPickup, ILinkModel{
	private ModelColorInit	modelColorInit;

	public String toString(){
		return "Random";
	}	

	public void setModel(IComponent model) {
		modelColorInit = (ModelColorInit)model;
		modelColorInit.insertPickup(this, 1);
	}

	public int[] getColor(AbstractAlgorithm algorithm) {
		int colorNumber = modelColorInit.getColorNumber();
		int[] colors = new int[colorNumber ];
		int[] intRGB = algorithm.getIntColors();
		int n = intRGB.length;
		for (int un = 0; un<colorNumber; un++) {
			int colorIndex = (int) (Math.random()*n);
			colors[un] = intRGB[colorIndex];
		}
		return colors;
	}
}