/*
 * PickupPreset.java
 *
 * Created on 2005/06/12, 18:38
 */

package jp.sourceforge.sos.cytoq.colorInit;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.IPickup;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.ILinkViewWrapper;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.lib.color.ColorPanelModel;
import jp.sourceforge.sos.lib.color.JPanelColor;
import jp.sourceforge.sos.lib.io.SOSFileIO;
import jp.sourceforge.sos.lib.variablePanel.JVariablePanel;
import jp.sourceforge.sos.lib.view.ViewMenuItem;

/**
 * @author Gaku Tanaka
 */
@SuppressWarnings("serial")
class PickupPreset extends JDialog implements IPickup, ILinkModel, ILinkViewWrapper {

	static private final File		file;

	static private final PresetData	DEFAULT_DATA	= new PresetData();

	private PresetData				currentData;

	private boolean					modified;
	
	private ModelColorInit				modelColor;

	private JPanel					jContentPane	= null;

	private JVariablePanel				jColorPanel		= null;

	private JPanel					jPanel			= null;

	private JButton					jButtonAdd		= null;

	private JButton					jButtonRename	= null;

	private JButton					jButtonRemove	= null;

	private JButton					jButtonUpdate	= null;

	private JPanel					jPanel1			= null;

	private JTextField				jTextName		= null;

	private JComboBox				jComboPresets	= null;

	private CardLayout				cardLayout		= new CardLayout();

	static {
		file = new File(System.getProperty("user.dir")+File.separator+"ColorPresets.dat");
		DEFAULT_DATA.setName("IHC3");
		DEFAULT_DATA.setData(new int[]{ -1, -6710785, -4939616 });
	}

	/** Creates new form PickupPreset */
	PickupPreset() {
		super(new JFrame(), false);
		initComponents();
		cardLayout.show(jPanel1, jComboPresets.getName());
		loadItem();
	}

	private void loadItem() {
		ArrayList<String> args = SOSFileIO.readStrings(file);
		if (args.size()==0) {
			jComboPresets.addItem(DEFAULT_DATA);
			return;
		}

		for (int i = 0; i<args.size(); i++) {
			PresetData data = new PresetData();
			data.set(args.get(i));
			jComboPresets.addItem(data);
		}
	}

	public String toString() {
		return "Preset";
	}

	private void saveItems() {
		String[] result = new String[jComboPresets.getItemCount()];
		for (int i = 0; i<result.length; i++) {
			PresetData data = (PresetData)jComboPresets.getItemAt(i);
			result[i] = data.getSaveString();
		}
		SOSFileIO.writeStrings(file, result);
	}

	private void rename() {
		jTextName.setText(currentData.toString());
		cardLayout.show(jPanel1, jTextName.getName());
		jTextName.requestFocus();
	}

	/**
	 * 
	 */
	private void setPresetName() {
		cardLayout.show(jPanel1, jComboPresets.getName());
		currentData.setName(jTextName.getText());

		pack();
		modified = true;
	}

	/**
	 * 
	 */
	private void init() {
		modelColor.setSelected(this);
		modified = false;
	}

	private void initComponents() {
		getContentPane().setLayout(new java.awt.GridBagLayout());

		setTitle("Preset Manager");

		this.setSize(new java.awt.Dimension(226, 164));
		this.setContentPane(getJContentPane());

		this.addComponentListener(new java.awt.event.ComponentAdapter() {
			public void componentHidden(java.awt.event.ComponentEvent e) {
				if (modified) {
					saveItems();
				}
			}

			public void componentShown(java.awt.event.ComponentEvent e) {
				init();
			}

		});

	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane==null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getPanelInit(), java.awt.BorderLayout.CENTER);
			jContentPane.add(getJPanel(), java.awt.BorderLayout.EAST);
			jContentPane.add(getJPanel1(), java.awt.BorderLayout.NORTH);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jColorPanel
	 * 
	 * @return jp.sourceforge.sos.lib.color.JColorPanel
	 */
	private JVariablePanel getPanelInit() {
		if (jColorPanel==null) {
			jColorPanel = new JPanelColor();
		}
		return jColorPanel;
	}

	/**
	 * This method initializes jPanel
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel() {
		if (jPanel==null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(4);
			gridLayout.setColumns(1);
			jPanel = new JPanel();
			jPanel.setLayout(gridLayout);
			jPanel.add(getJButtonUpdate(), null);
			jPanel.add(getJButtonRename(), null);
			jPanel.add(getJButtonRemove(), null);
			jPanel.add(getJButtonAdd(), null);
		}
		return jPanel;
	}

	/**
	 * This method initializes jButtonAddi
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButtonAdd() {
		if (jButtonAdd==null) {
			jButtonAdd = new JButton();
			jButtonAdd.setText("ADD");
			jButtonAdd.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					jComboPresets.addItem(new PresetData("New Preset", getColorInt(jColorPanel)));
					jComboPresets.setSelectedIndex(jComboPresets.getItemCount()-1);
					rename();
					pack();

					modified = true;
				}
			});
		}
		return jButtonAdd;
	}

	/**
	 * This method initializes jButtonRen
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButtonRename() {
		if (jButtonRename==null) {
			jButtonRename = new JButton();
			jButtonRename.setText("RENAME");
			jButtonRename.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					rename();
				}
			});
		}
		return jButtonRename;
	}

	/**
	 * This method initializes jButtonRemo
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButtonRemove() {
		if (jButtonRemove==null) {
			jButtonRemove = new JButton();
			jButtonRemove.setText("REMOVE");
			jButtonRemove.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					int index = jComboPresets.getSelectedIndex();
					jComboPresets.removeItemAt(index);
					modified = true;
				}
			});
		}
		return jButtonRemove;
	}

	/**
	 * This method initializes jButtonUpd
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButtonUpdate() {
		if (jButtonUpdate==null) {
			jButtonUpdate = new JButton();
			jButtonUpdate.setText("UPDATE");
			jButtonUpdate.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					PresetData data = (PresetData)jComboPresets.getSelectedItem();
					data.setData(getColorInt(jColorPanel));
					modified = true;
				}
			});
		}
		return jButtonUpdate;
	}

	protected int[] getColorInt(JVariablePanel colorPanel) {
		ColorPanelModel model = (ColorPanelModel) colorPanel.getModel();
		int[] result = new int[model.getNumber()];
		for (int i = 0; i<result.length; i++) {
			result[i] = model.getColorInt(i);
		}
		return result;
	}

	/**
	 * This method initializes jPanel1
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel1() {
		if (jPanel1==null) {
			jPanel1 = new JPanel();
			jPanel1.setLayout(cardLayout);
			jPanel1.add(getJTextName(), getJTextName().getName());
			jPanel1.add(getJComboPresets(), getJComboPresets().getName());
		}
		return jPanel1;
	}

	/**
	 * This method initializes jTextField
	 * 
	 * @return javax.swing.JTextField
	 */
	private JTextField getJTextName() {
		if (jTextName==null) {
			jTextName = new JTextField();
			jTextName.setName("jTextName");
			jTextName.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					setPresetName();
				}
			});
			jTextName.addFocusListener(new java.awt.event.FocusAdapter() {
				public void focusLost(java.awt.event.FocusEvent e) {
					setPresetName();
				}
			});
		}
		return jTextName;
	}

	/**
	 * This method initializes jComboBox
	 * 
	 * @return javax.swing.JComboBox
	 */
	private JComboBox getJComboPresets() {
		if (jComboPresets==null) {
			jComboPresets = new JComboBox();
			jComboPresets.setName("jComboPresets");
			jComboPresets.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					currentData = (PresetData)jComboPresets.getSelectedItem();
					if (modelColor!=null) {
						modelColor.init();
					}
				}
			});
		}
		return jComboPresets;
	}

	@SuppressWarnings("unchecked")
	public void setModel(IComponent model) {
		modelColor = (ModelColorInit)model;
		jColorPanel.setLabelName("Initial");
		jColorPanel.setModel(modelColor.getColorModel());
		jColorPanel.setLabelBase("#");
		((JPanelColor) jColorPanel).setChoosable(true);

		modelColor.insertPickup(this, 0);
	}

	public JComponent getWrapper() {
		return new ViewMenuItem(this);
	}

	public String getContainer() {
		return "jMenuTools";
	}

	public Object getConstraints() {
		return NO_CONSTRAINT;
	}

	public int[] getColor(AbstractAlgorithm algorithm) {
		PresetData data = (PresetData)jComboPresets.getSelectedItem();
		return data.getData();
	}

}

