package jp.sourceforge.sos.cytoq.colorInit;

import javax.swing.ComboBoxModel;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.IPickup;
import jp.sourceforge.sos.cytoq.main.ModelMain;
import jp.sourceforge.sos.cytoq.message.IInitSection;
import jp.sourceforge.sos.framework.IInitializeLast;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.pattern.ComboModelStrategy;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.color.ColorPanelModel;
import jp.sourceforge.sos.lib.colorspace.SOSColorSpace;

public class ModelColorInit extends AbstractModel<ModelMain> implements IInitializeLast, IInitSection{
	
	public ColorPanelModel				colorModel;

	private ComboModelStrategy<IPickup>	pickups;
	
	public ModelColorInit() {
		pickups = new ComboModelStrategy<IPickup>();
		pickups.add(new PickupNull());
		
		colorModel = new ColorPanelModel();
		colorModel.setName("Initial");
	}
	
	@Override
	protected void initModel() {
	}
	
	public ColorPanelModel getColorModel() {
		return colorModel;
	}

	void insertPickup(IPickup pickup, int index) {
		pickups.insertElementAt(pickup, index);
	}

	public int getColorNumber() {
		return colorModel.getNumber();
	}

	ComboBoxModel getPickups() {
		return pickups;
	}

	IPickup getPickup() {
		return pickups.getSelected();
	}
	
	void setSelected(IPickup pickup) {
		pickups.setSelectedItem(pickup);
	}

	public void observeInitSection(AbstractAlgorithm changed) {
		int[] color = changed.getUnitColor();
		if (color!=null){
			setCurrentPickup(1);
			updateColor(color);
		}else{
			setColors();
		}
		double[][] u = modelParent.getColorSpace().fromRGB(colorModel.getColorArray());
		changed.setUnit(u);
	}

	public void init() {
		setCurrentPickup(0);
		setColors();
	}

	private void setCurrentPickup(int index) {
		IPickup current = (IPickup) pickups.getElementAt(index);
		pickups.setSelectedItem(current);
	}

	private void setColors() {
		IPickup current = pickups.getSelected();
		int[] color = current.getColor(modelParent.getAlgorithm());
		if (0<color.length){
			updateColor(color);
		}
	}

	public void updateColor(int[] color) {
		updateColorNumber(color.length);
		colorModel.updateColor(color);
	}

	void updateColorNumber(int n) {
		colorModel.setNumber(n);
	}

	public void addObserverInitColor(IObserver<ColorModel> obj){
		colorModel.addObserver(obj);
	}

	public SOSColorSpace getColorSpace() {
		return modelParent.getColorSpace();
	}

}
