package jp.sourceforge.sos.cytoq.colorFinal;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JButton;
import javax.swing.JPanel;

import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.lib.color.JPanelColor;
import jp.sourceforge.sos.lib.variablePanel.JVariablePanel;

@SuppressWarnings("serial")
public class ViewPanel extends JPanel implements ILinkModel, ILinkContainer {
	private ModelColorFinal	modelColor;

	private JButton			jButton;

	private JVariablePanel		jColorPanel;

	private JPanel			jPanel;

	/**
	 * This is the default constructor
	 */
	public ViewPanel() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.gridx = 1;
		gridBagConstraints1.gridy = 0;
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.ipady = 27;
		gridBagConstraints.gridheight = 1;
		gridBagConstraints.gridy = 0;
		this.setLayout(new GridBagLayout());
		this.add(getJButton(), gridBagConstraints);
		this.add(getJPanel4(), gridBagConstraints1);
	}

	/**
	 * This method initializes jButton
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButton() {
		if (jButton==null) {
			jButton = new JButton();
			jButton.setText("<<");
			jButton.setPreferredSize(new java.awt.Dimension(22,10));
			jButton.setMargin(new Insets(1, 1, 1, 1));
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					modelColor.transferToInit();
				}
			});
		}
		return jButton;
	}

	/**
	 * This method initializes jPanel4
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel4() {
		if (jPanel==null) {
			jPanel = new JPanel();
			jPanel.setLayout(new BorderLayout());
			jPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Final", javax.swing.border.TitledBorder.LEADING,
					javax.swing.border.TitledBorder.TOP, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), java.awt.Color.blue));
			jPanel.add(getJColorPanel(), java.awt.BorderLayout.NORTH);
		}
		return jPanel;
	}

	/**
	 * This method initializes jColorPanel1
	 * 
	 * @return jp.sourceforge.sos.lib.color.JColorPanel
	 */
	private JVariablePanel getJColorPanel() {
		if (jColorPanel==null) {
			jColorPanel = new JPanelColor();
		}
		return jColorPanel;
	}

	@SuppressWarnings("unchecked")
	public void setModel(IComponent model) {
		modelColor = (ModelColorFinal)model;

		jColorPanel.setModel(modelColor.getColorModel());
		jColorPanel.setLabelBase("#");
		((JPanelColor) jColorPanel).setChoosable(false);
	}

	public String getContainer() {
		return "jp.sourceforge.sos.cytoq.colorInit.ViewPanel.jPanelColorModels";
	}

	public Object getConstraints() {
		return BorderLayout.CENTER;
	}

}
