package jp.sourceforge.sos.cytoq.colorFinal;

import jp.sourceforge.sos.cytoq.colorInit.ModelColorInit;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.color.ColorPanelModel;
import jp.sourceforge.sos.lib.colorspace.SOSColorSpace;

public class ModelColorFinal extends AbstractModel<ModelColorInit> implements IObserver<ColorModel>{

	private ColorPanelModel			colorModel;
	
	
	public ModelColorFinal() {
		colorModel = new ColorPanelModel();
		colorModel.setName("Final");
	}
	
	void transferToInit() {
		int[] colors = colorModel.getColorInt();
		modelParent.updateColor(colors);
	}

	@Override
	protected void initModel() {
		modelParent.addObserverInitColor(this);
	}

	public void setColorData(double[][] units) {
		if (units!=null) {
			SOSColorSpace colorSpace = modelParent.getColorSpace();
			colorModel.updateColor(colorSpace.toRGB(units));
		}
	}

	public ColorPanelModel getInitColors() {
		return modelParent.getColorModel();
	}

	public ColorPanelModel getColorModel() {
		return colorModel;
	}

	public void update(ColorModel changed) {
		int n = modelParent.getColorNumber();
		colorModel.setNumber(n);
	}

	public int getColorNumber() {
		return modelParent.getColorNumber();
	}

	public int[] getColor() {
		return colorModel.getColorInt();
	}

	public void addObserverInitColor(IObserver<ColorModel> obj) {
		modelParent.addObserverInitColor(obj);
	}
}
