package jp.sourceforge.sos.cytoq;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.TreeMap;

import javax.swing.JComboBox;

import jp.sourceforge.sos.cytoq.main.AbstractFileHandler;
import jp.sourceforge.sos.lib.image.ImageColors;
import jp.sourceforge.sos.lib.image.ImagePixelMediator;
import jp.sourceforge.sos.lib.image.LabeledImage;
import jp.sourceforge.sos.lib.math.Clustering;
import jp.sourceforge.sos.lib.math.IOptionComponent;

/**
 * 
 * @author Scientific Open Source project (Gaku Tanaka)
 */
public abstract class AbstractAlgorithm<T> extends Clustering implements
		IOptionComponent<T> {

	static protected ImageColors imageColor;

	static private LabeledImage labeledImage;
	
	protected AbstractFileHandler fileHandler;
	
	protected int[]	histogram;
	
	static{
		imageColor = new ImageColors();
		labeledImage = new LabeledImage();
	}
	
	public abstract boolean isConvoluted();

	public abstract void calculate();

	public abstract boolean initProcess();
	
	public String toString() {
		return getClass().getName();
	}

	public void setFileHandler(AbstractFileHandler fileHandler) {
		this.fileHandler = fileHandler;
	}

	public String getName() {
		return getLabeledImage().getName();
	}

	public int[] getIntColors() {
		return imageColor.getIntColors();
	}

	public LabeledImage getLabeledImage() {
		return labeledImage;
	}
	
	public final void initSection() {
		fileHandler.next();
		File file = fileHandler.getCurrentFile();
		if (file!=null){
			initSection(file);
		}
	}

	public abstract void initSection(File file);

	protected void makeImageColors(File file) {
		TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
		imageColor.makeMap(file, map);
		imageColor.setupFromMap(map);
	}

	protected void makeLabeledImage(File file) {
		labeledImage.setFile(file);
		labeledImage.makePixelsColorsTable(imageColor);
	}

	public ImageColors getImageColor() {
		return imageColor;
	}
	
	public int[] getUnitColor(){
		return null;
	}

	public void confineFile(JComboBox obj) {
		obj.setEnabled(true);
	}

	public void endProcess() {
	}
	
	protected int[] getIntArray(BufferedImage img) {
		if (img==null){
			return null;
		}
		
		int[] a = ImagePixelMediator.toPixels(img);
		int[] result = new int[a.length];
		for (int i = 0; i < a.length; i++) {
			result[i] = a[i] & 0xffffff;
		}
		return result;
	}
}
