import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.lib.image.ImageColors;
import jp.sourceforge.sos.lib.image.ImagePixelMediator;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.util.MinMaxInteger;

/**
 * The abstract class for clastering algorithms.
 * 
 * @author Scientific Open Source projects (Gaku Tanaka)
 */
public class Matching extends AbstractAlgorithm<ImageColors> {

	private SOSImageIO imageIO = SOSImageIO.getInstance();

	private int[] colors;

	private int[] labels;

	private int[] unitColor;

	public void calculate() {
		int[] c = imageColor.getIntColors();
		for (int i = 0; i < c.length; i++) {
			int index = Arrays.binarySearch(colors, c[i]);
			cluster[i] = labels[index];
		}
		cumulate();
		calcMean(true);
	}

	public void setParameter(ImageColors obj) {
	}

	public boolean isConvoluted() {
		return true;
	}

	@Override
	public boolean initProcess() {
		colors = getIntArray(getImage("COLORS"));
		labels = getLabel(getImage("LABELS"));
		if (colors == null || labels == null) {
			return false;
		}
		int n = findMaxLabel() + 1;
		unitColor = new int[n];
		createUnitColor();
		return true;
	}

	private int[] getLabel(BufferedImage image) {
		int[] pixels = ImagePixelMediator.toPixels(image);
		int[] result = new int[pixels.length];
		ArrayList<Integer> list = new ArrayList<Integer>();
		for (int i=0; i<result.length; i++){
			result[i]  = list.indexOf(pixels[i]);
			if (result[i]==-1){
				result[i] = list.size();
				list.add(pixels[i]);
			}
		}
		return result;
	}

	private BufferedImage getImage(String arg) {
		String s = "Select the image of " + arg + ".";
		return imageIO.readImage(s);
	}

	private int findMaxLabel() {
		MinMaxInteger mmi = new MinMaxInteger();
		mmi.compareMax(labels);
		return mmi.getValue();
	}

	private void createUnitColor() {
		long[][] vectors = new long[unitColor.length][3];
		int[] counts = new int[unitColor.length];
		for (int i = 0; i < colors.length; i++) {
			int index = labels[i];
			counts[index]++;
			vectors[index][0] += (colors[i] >> 16) & 0xff;
			vectors[index][1] += (colors[i] >> 8) & 0xff;
			vectors[index][2] += (colors[i] >> 0) & 0xff;
		}

		for (int i = 0; i < unitColor.length; i++) {
			int r = (int) (vectors[i][0] / counts[i]);
			int g = (int) (vectors[i][1] / counts[i]);
			int b = (int) (vectors[i][2] / counts[i]);
			unitColor[i] = (r << 16) + (g << 8) + b;
		}
	}

	public int[] getUnitColor() {
		return unitColor;
	}

	@Override
	public void initSection(File file) {
		makeImageColors(file);
		makeLabeledImage(file);
	}

}