
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;

import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.lib.image.ImageColors;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.panel.JGenericPanel;

/**
 * The abstract class for clastering algorithms.
 * 
 * @author Scientific Open Source projects (Gaku Tanaka)
 */
public class KMeans extends AbstractAlgorithm<ImageColors> {

	protected static final String pathChunk = "UnknownChunks/UnknownChunk";

	protected static final String[] attr = new String[] { "type/tkFl" };

	protected int indexParameter;

	public KMeans() {
		String[] colorType = new String[] { "full color", "all pixels" };
		JGenericPanel panel = new JGenericPanel();
		panel.addChoice("sampling", colorType, 0);
		optionPanel = panel;
	}

	public void calculate() {
		initCalculation();
		findNearestMean(input);
		if (histogram == null) {
			cumulate();
		} else {
			cumulate(histogram);
		}
		calcMean(true);
	}

	public boolean isConvoluted() {
		return (evaluatedValue < desiredValue);
	}

	@Override
	public boolean initProcess() {
		setParameter(null);
		return true;
	}

	public void setParameter(ImageColors obj) {
		indexParameter = ((JGenericPanel) optionPanel).getChoiceIndex(0);
	}

	@Override
	public void initSection(File file) {
		int[] h = getMetadataObject(file);
		if (h!=null){
			int[] colors = getIntArray(SOSImageIO.readImage(file));
			imageColor.setIntColors(colors);
			imageColor.setHistogram(h);
		}else{
			makeImageColors(file);
		}
		makeLabeledImage(file);
		histogram = (indexParameter == 0) ? null : imageColor.getHistogram();
	}
	
	private int[] getMetadataObject(File file) {
		IIOMetadata metadata = SOSImageIO.getMetadata(file);
		if (metadata == null) {
			return null;
		}
		
		byte[] data = null;
		try {
			IIOMetadataNode root = (IIOMetadataNode) metadata
					.getAsTree(metadata.getNativeMetadataFormatName());
			IIOMetadataNode node = SOSImageIO.getNode(root, pathChunk, attr);
			if (node != null) {
				data = (byte[]) node.getUserObject();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return getObject(data);
	}

	private int[] getObject(byte[] data) {
		int[] result = null;
		if (data != null) {
			try {
				ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
				ObjectInputStream objectIn = new ObjectInputStream(byteIn);
				result = (int[]) objectIn.readObject();
				objectIn.close();
				byteIn.close();
			} catch (StreamCorruptedException e) {
				// invalid data in the COMMENT_SEGMENT of the jpeg file
				System.out.println("Error but OK");
			} catch (ClassCastException e) {
				// invalid data in the COMMENT_SEGMENT of the jpeg file
				System.out.println("Error but OK");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return result;
	}

}