import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.TreeMap;

import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.swing.JComboBox;

import jp.sourceforge.sos.lib.image.ImageColors;
import jp.sourceforge.sos.lib.image.ImagePixelMediator;
import jp.sourceforge.sos.lib.io.Extension;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.window.JProgressDialog;

/**
 * The abstract class for clastering algorithms.
 * 
 * @author Scientific Open Source projects (Gaku Tanaka)
 */
public class AKMeans extends KMeans {
	public AKMeans() {
		super();
	}

	@Override
	public boolean initProcess() {
		super.initProcess();

		File dir = fileHandler.getDir();
		if (dir == null) {
			return false;
		}

		imageColor = new ImageColors();
		TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
		File[] files = dir.listFiles();

		JProgressDialog dialog = new JProgressDialog(null);
		dialog.start("Loading images...", false);
		for (int i = 0; i < files.length; i++) {
			imageColor.makeMap(files[i], map);
			dialog.setValue(100 * i / files.length);
		}
		dialog.stop();

		imageColor.setupFromMap(map);
		histogram = (indexParameter == 0) ? null : imageColor.getHistogram();

		return true;
	}

	@Override
	public void initSection(File file) {
		makeLabeledImage(file);
	}

	public void confineFile(JComboBox obj) {
		obj.setSelectedIndex(0);
		obj.setEnabled(false);
	}
	public void endProcess() {
		int[] pixels = imageColor.getIntColors();
		Dimension size = findSize(pixels.length);
		
		BufferedImage img = ImagePixelMediator.toImage(pixels, size.width, size.height);
		IIOMetadata metadata = createMetadata(img);
		String dir = fileHandler.getCurrentFile().getParent();
		String path = dir+File.separator+"acc.png";
		File file = new File(Extension.replace(path, "png"));
		SOSImageIO.writeImage(file, img, metadata);
	}

	private IIOMetadata createMetadata(BufferedImage img) {
		byte[][] byteData = convertToByte(imageColor.getHistogram());
		IIOMetadata metadata = SOSImageIO.getDefaultMetadata("png", img);
		IIOMetadataNode node = (IIOMetadataNode) metadata.getAsTree(metadata
				.getNativeMetadataFormatName());
		IIOMetadataNode privateChunk =  SOSImageIO.addNode(node, pathChunk, attr);
		privateChunk.setUserObject(byteData[0]);
		try {
			metadata.setFromTree(metadata.getNativeMetadataFormatName(), node);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return metadata;
	}
	
	private Dimension findSize(int length) {
		int max = (int) Math.sqrt(length);
		int height = 1;
		for (int i=1; i<max; i++){
			if (0==length%i){
				height = i;
			}
		}
		return new Dimension(length/height, height);
	}

	private byte[][] convertToByte(int[] result) {
		byte[][] data = new byte[1][];
		try {
			ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
			ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
			objectOut.writeObject(result);
			objectOut.flush();
			data[0] = byteOut.toByteArray();

			objectOut.close();
			byteOut.close();
		} catch (NotSerializableException e) {
			System.out.println("Serializable error");
			e.printStackTrace();
		} catch (Exception e) {
			System.out.println("Other error");
		}
		return data;
	}

}