/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework.thread;

import jp.sourceforge.sos.framework.thread.IProcess;

class ThreadProcess
implements Runnable {
    private IProcess process;
    private volatile boolean threadSuspended;
    private Thread blinker;
    private int interval = 5;

    ThreadProcess() {
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        do {
            this.sleep(thisThread);
        } while (!this.process.isFinished());
        this.endLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(Thread thisThread) {
        try {
            Thread.sleep(this.interval);
            ThreadProcess threadProcess = this;
            synchronized (threadProcess) {
                while (this.threadSuspended && this.blinker == thisThread) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void start(IProcess process) {
        this.process = process;
        this.threadSuspended = false;
        this.blinker = new Thread(this);
        this.blinker.start();
    }

    private synchronized void endLoop() {
        this.blinker = null;
        this.notify();
        this.process.endProcess();
    }

    public synchronized boolean changeStatus() {
        boolean bl = this.threadSuspended = !this.threadSuspended;
        if (!this.threadSuspended) {
            this.notify();
        }
        return this.threadSuspended;
    }

    public void setInterval(int i) {
        this.interval = i;
    }
}

