/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework.thread;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.framework.thread.AbstractThread;
import jp.sourceforge.sos.framework.thread.ThreadStatus;

public class JButtonThread
extends JPanel
implements IObserver<ThreadStatus> {
    private static final long serialVersionUID = 167955350386272895L;
    private JButton jButton = null;
    private JButton jButtonStop = null;
    private AbstractThread modelThread;

    public JButtonThread() {
        this.initialize();
    }

    public void setModelThread(AbstractThread modelThread) {
        this.modelThread = modelThread;
        modelThread.addObserver(this);
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(2);
        this.setLayout(gridLayout);
        this.add((Component)this.getJButton(), null);
        this.add((Component)this.getJButtonStop(), null);
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("START");
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButtonThread.this.changeStatus();
                }
            });
        }
        return this.jButton;
    }

    private void changeStatus() {
        String arg = this.modelThread.changeProcessStatus(this.jButton.getText());
        this.jButton.setText(arg);
    }

    private JButton getJButtonStop() {
        if (this.jButtonStop == null) {
            this.jButtonStop = new JButton();
            this.jButtonStop.setEnabled(false);
            this.jButtonStop.setText("STOP");
            this.jButtonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButtonThread.this.modelThread.endProcess();
                    JButtonThread.this.stopThread();
                }
            });
        }
        return this.jButtonStop;
    }

    @Override
    public void update(ThreadStatus changed) {
        switch (changed) {
            case START: {
                this.startThread();
                break;
            }
            case STOP: {
                this.stopThread();
            }
        }
    }

    private void startThread() {
        this.jButtonStop.setEnabled(true);
    }

    private void stopThread() {
        this.jButton.setText(ThreadStatus.START.toString());
        this.jButtonStop.setEnabled(false);
    }
}

