/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework.thread;

import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.pattern.IObservable;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.framework.pattern.ObserverSet;
import jp.sourceforge.sos.framework.thread.IProcess;
import jp.sourceforge.sos.framework.thread.ThreadProcess;
import jp.sourceforge.sos.framework.thread.ThreadStatus;

public abstract class AbstractThread<T extends AbstractModel>
extends AbstractModel<T>
implements IProcess,
IObservable<ThreadStatus> {
    protected ThreadProcess threadProcess = new ThreadProcess();
    protected long startTime;
    protected int countSection;
    private int maxSection;
    protected int countStep;
    protected int maxStep;
    private int animationStep;
    protected boolean ready;
    private ObserverSet<ThreadStatus> observers = new ObserverSet();
    private boolean convoluted;

    public long getTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public int getCountStep() {
        return this.countStep;
    }

    public int getCountSection() {
        return this.countSection;
    }

    public int getMaxStep() {
        return this.maxStep;
    }

    public int getMaxSection() {
        return this.maxSection;
    }

    public void setMaxStep(int value) {
        this.maxStep = value;
    }

    public void setMaxSection(int value) {
        this.maxSection = value;
    }

    public void setAnimationStep(int value) {
        this.animationStep = this.maxStep < value ? this.maxStep : value;
    }

    public synchronized String changeProcessStatus(String arg) {
        ThreadStatus current = arg.equals(ThreadStatus.START.toString()) ? this.startProcess() : (this.threadProcess.changeStatus() ? ThreadStatus.RESUME : ThreadStatus.SUSPEND);
        return current.toString();
    }

    public ThreadStatus startProcess() {
        this.ready = true;
        this.initProcess();
        if (this.ready) {
            this.initSection();
            this.threadProcess.start(this);
            this.observers.notify(ThreadStatus.START);
            return ThreadStatus.SUSPEND;
        }
        return ThreadStatus.START;
    }

    protected void initProcess() {
        this.countSection = 0;
    }

    protected void initSection() {
        ++this.countSection;
        this.countStep = 0;
        this.convoluted = false;
        this.startTime = System.currentTimeMillis();
    }

    protected abstract void mainLoop();

    protected abstract void endAnimationStep();

    protected boolean isConvoluted() {
        return true;
    }

    protected void endSection() {
    }

    @Override
    public boolean isFinished() {
        int i = 0;
        while (i < this.animationStep) {
            this.mainLoop();
            ++this.countStep;
            if (this.isConvoluted() || this.maxStep <= this.countStep) {
                this.convoluted = true;
                break;
            }
            ++i;
        }
        this.endAnimationStep();
        if (!this.convoluted) {
            return false;
        }
        this.endSection();
        if (this.countSection < this.maxSection) {
            this.initSection();
            return false;
        }
        this.endProcess();
        return true;
    }

    @Override
    public void endProcess() {
        this.observers.notify(ThreadStatus.STOP);
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    @Override
    public void addObserver(IObserver<ThreadStatus> observer) {
        this.observers.addObserver(observer);
    }

    @Override
    public void removeObserver(IObserver<ThreadStatus> obj) {
        this.observers.removeObserver(obj);
    }

    @Override
    public void clearObserver() {
        this.observers.clearObserver();
    }
}

