/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework.model;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import jp.sourceforge.sos.framework.AbstractBuilder;
import jp.sourceforge.sos.framework.loader.ClassFactory;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.model.IComponent;

public class ManagerModel {
    private IComponent currentModel;
    private DefaultMutableTreeNode root;

    public void build(AbstractBuilder builder) {
        String rootPath = builder.getRootPath();
        HashSet files = ClassFactory.createAllInstances(rootPath, AbstractModel.class);
        HashMap<Class, Object> map = this.createMap(files);
        this.root = this.getMainModel(map);
        this.createModelTree(map);
        this.replaceModel(map);
        this.setupModels(builder);
    }

    private HashMap<Class, Object> createMap(HashSet files) {
        HashMap<Class, Object> map = new HashMap<Class, Object>();
        for (Object obj : files) {
            Class<?> cls = obj.getClass();
            map.put(cls, obj);
        }
        return map;
    }

    private DefaultMutableTreeNode getMainModel(HashMap<Class, Object> map) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        Set<Class> keys = map.keySet();
        for (Class cls : keys) {
            String name = cls.getSimpleName();
            if (!name.equals("ModelMain")) continue;
            Object obj = map.get(cls);
            map.remove(cls);
            node.setUserObject(obj);
            break;
        }
        return node;
    }

    private void createModelTree(HashMap<Class, Object> map) {
        HashSet<Class> removable = new HashSet<Class>();
        do {
            removable.clear();
            this.connectToParentNode(map, removable);
            for (Class cls : removable) {
                map.remove(cls);
            }
        } while (!removable.isEmpty());
    }

    private void connectToParentNode(HashMap<Class, Object> map, HashSet<Class> removable) {
        Set<Class> keys = map.keySet();
        for (Class cls : keys) {
            Type type = cls.getGenericSuperclass();
            DefaultMutableTreeNode parent = this.getParent(type);
            if (parent == null) continue;
            Object obj = map.get(cls);
            removable.add(cls);
            parent.add(new DefaultMutableTreeNode(obj));
        }
    }

    private DefaultMutableTreeNode getParent(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pType = (ParameterizedType)type;
        Type[] generics = pType.getActualTypeArguments();
        DefaultMutableTreeNode parent = this.getNodeFromTree(generics[0]);
        return parent;
    }

    private DefaultMutableTreeNode getNodeFromTree(Type type) {
        Enumeration<TreeNode> it = this.root.breadthFirstEnumeration();
        while (it.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)it.nextElement();
            Object model = node.getUserObject();
            if (!((Class)type).isInstance(model)) continue;
            return node;
        }
        return null;
    }

    private void replaceModel(HashMap<Class, Object> map) {
        Set<Class> keys = map.keySet();
        for (Class cls : keys) {
            Class superClass = cls.getSuperclass();
            DefaultMutableTreeNode node = this.getNodeFromTree(superClass);
            if (node == null) continue;
            Object obj = map.get(cls);
            node.setUserObject(obj);
        }
    }

    private void setupModels(AbstractBuilder builder) {
        DefaultMutableTreeNode invisibleRoot = new DefaultMutableTreeNode();
        invisibleRoot.add(this.root);
        Enumeration<TreeNode> it = invisibleRoot.breadthFirstEnumeration();
        while (it.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)it.nextElement();
            this.setupCurrent(builder, node);
        }
    }

    private void setupCurrent(AbstractBuilder builder, DefaultMutableTreeNode node) {
        IComponent parent = (IComponent)node.getUserObject();
        int i = 0;
        while (i < node.getChildCount()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            this.currentModel = (IComponent)child.getUserObject();
            this.currentModel.setModel(parent);
            builder.link(this.currentModel);
            builder.setModel(this.currentModel);
            ++i;
        }
    }

    public IComponent getCurrentModel() {
        return this.currentModel;
    }

    public IComponent getModel(Class ancestor) {
        DefaultMutableTreeNode node = this.getNodeFromTree(ancestor);
        if (node != null) {
            return (IComponent)node.getUserObject();
        }
        return null;
    }
}

