/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework.message;

import java.util.HashMap;
import java.util.HashSet;
import jp.sourceforge.sos.framework.ILinkMultiCast;
import jp.sourceforge.sos.framework.loader.ClassFactory;
import jp.sourceforge.sos.framework.message.AbstractSubject;
import jp.sourceforge.sos.framework.message.SubjectNotFoundException;

public class ManagerMultiCast {
    private HashMap<Class<ILinkMultiCast>, AbstractSubject> subjects = new HashMap();

    public ManagerMultiCast(String root) {
        HashSet subs = ClassFactory.createInstances(String.valueOf(root) + ".message", AbstractSubject.class);
        for (AbstractSubject sub : subs) {
            this.subjects.put(sub.getObserverClass(), sub);
        }
    }

    public void add(ILinkMultiCast obj) {
        for (Class<ILinkMultiCast> cls : this.subjects.keySet()) {
            if (!cls.isInstance(obj)) continue;
            AbstractSubject subject = this.subjects.get(cls);
            subject.addObserver(obj);
        }
    }

    public void inform(Class<? extends ILinkMultiCast> key, Object changed) {
        AbstractSubject subject = this.subjects.get(key);
        if (subject != null) {
            subject.inform(changed);
        }
    }

    public HashSet<ILinkMultiCast> getObservers(Class key) throws SubjectNotFoundException {
        AbstractSubject subject = this.subjects.get(key);
        if (subject == null) {
            throw new SubjectNotFoundException();
        }
        return subject.getObservers();
    }
}

