/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework.loader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PluginClassLoader
extends ClassLoader {
    protected String path;
    protected Hashtable cache = new Hashtable();
    protected Vector<File> jarFiles;

    public PluginClassLoader(String path) {
        this.path = path;
        this.jarFiles = new Vector();
        File f = new File(path);
        String[] list = f.list();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            f = new File(path, list[i]);
            if (f.isDirectory()) {
                String[] innerlist = f.list();
                if (innerlist != null) {
                    int j = 0;
                    while (j < innerlist.length) {
                        File g = new File(f, innerlist[j]);
                        if (g.isFile()) {
                            this.addJAR(g);
                        }
                        ++j;
                    }
                }
            } else {
                this.addJAR(f);
            }
            ++i;
        }
    }

    private void addJAR(File f) {
        if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
            this.jarFiles.addElement(f);
        }
    }

    @Override
    public URL getResource(String name) {
        File resFile;
        URL res = ClassLoader.getSystemResource(name);
        if (res != null) {
            return res;
        }
        try {
            resFile = new File(this.path, name);
            if (resFile.exists()) {
                res = this.makeURL(resFile);
                return res;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        resFile = new File(this.path);
        String[] list = resFile.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                resFile = new File(this.path, list[i]);
                if (resFile.isDirectory()) {
                    try {
                        File f = new File(String.valueOf(this.path) + list[i], name);
                        if (f.exists()) {
                            res = this.makeURL(f);
                            return res;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return this.lookInJar(name);
    }

    ZipFile getJar(String name) {
        ZipFile result = null;
        int i = 0;
        while (i < this.jarFiles.size()) {
            File jf = this.jarFiles.elementAt(i);
            try {
                result = new ZipFile(jf.getPath());
                Enumeration<? extends ZipEntry> entries = result.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(name)) continue;
                    return result;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return null;
    }

    URL lookInJar(String name) {
        int i = 0;
        while (i < this.jarFiles.size()) {
            try {
                File jf = this.jarFiles.elementAt(i);
                byte[] resourceBytes = this.loadFromJar(jf.getPath(), name);
                if (resourceBytes != null) {
                    URL res = this.makeURL(name, jf);
                    return res;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return null;
    }

    private URL makeURL(File fil) throws MalformedURLException {
        URL url = new URL("file", "", fil.toString());
        return url;
    }

    private URL makeURL(String name, File jar) throws MalformedURLException {
        StringBuffer filename = new StringBuffer("file:///");
        filename.append(jar.toString());
        filename.append("!/");
        filename.append(name);
        String sf = filename.toString();
        String sfu = sf.replace('\\', '/');
        URL url = new URL("jar", "", sfu);
        return url;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = ClassLoader.getSystemResourceAsStream(name);
        if (is != null) {
            return is;
        }
        File resFile = new File(this.path, name);
        try {
            is = new FileInputStream(resFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is != null) {
            return is;
        }
        resFile = new File(this.path);
        String[] list = resFile.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                resFile = new File(this.path, list[i]);
                if (resFile.isDirectory()) {
                    try {
                        File f = new File(String.valueOf(this.path) + list[i], name);
                        is = new FileInputStream(f);
                    }
                    catch (Exception f) {
                        // empty catch block
                    }
                    if (is != null) {
                        return is;
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.jarFiles.size()) {
            try {
                File jf = this.jarFiles.elementAt(i);
                byte[] resourceBytes = this.loadFromJar(jf.getPath(), name);
                if (resourceBytes != null) {
                    is = new ByteArrayInputStream(resourceBytes);
                    return is;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return null;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        Class<?> result = (Class<?>)this.cache.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = super.findSystemClass(className);
            return result;
        }
        catch (Exception exception) {
            byte[] classBytes = this.loadClassBytes(className);
            if (classBytes == null) {
                throw new ClassNotFoundException(className);
            }
            result = this.defineClass(className, classBytes, 0, classBytes.length);
            if (result == null) {
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(result);
            }
            this.cache.put(className, result);
            return result;
        }
    }

    protected byte[] loadClassBytes(String name) {
        byte[] classBytes = null;
        classBytes = this.loadIt(this.path, name);
        if (classBytes == null && (classBytes = this.loadFromSubdirectory(this.path, name)) == null) {
            int i = 0;
            while (i < this.jarFiles.size()) {
                try {
                    File jf = this.jarFiles.elementAt(i);
                    classBytes = this.loadClassFromJar(jf.getPath(), name);
                    if (classBytes != null) {
                        return classBytes;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        return classBytes;
    }

    private byte[] loadIt(String path, String classname) {
        String filename = classname.replace('.', '/');
        filename = String.valueOf(filename) + ".class";
        File fullname = new File(path, filename);
        try {
            FileInputStream is = new FileInputStream(fullname);
            int bufsize = (int)fullname.length();
            byte[] buf = new byte[bufsize];
            ((InputStream)is).read(buf, 0, bufsize);
            ((InputStream)is).close();
            return buf;
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[] loadFromSubdirectory(String path, String name) {
        File f = new File(path);
        String[] list = f.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                byte[] buf;
                f = new File(path, list[i]);
                if (f.isDirectory() && (buf = this.loadIt(String.valueOf(path) + list[i], name)) != null) {
                    return buf;
                }
                ++i;
            }
        }
        return null;
    }

    byte[] loadClassFromJar(String jar, String className) {
        String name = className.replace('.', '/');
        name = String.valueOf(name) + ".class";
        return this.loadFromJar(jar, name);
    }

    /*
     * Exception decompiling
     */
    byte[] loadFromJar(String jar, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

