/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework.loader;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import jp.sourceforge.sos.framework.loader.ArchivesFileSystem;
import jp.sourceforge.sos.framework.loader.ArchivesJarFile;
import jp.sourceforge.sos.framework.loader.IArchive;

public class ClassFactory {
    private static HashMap<String, IArchive> archives = new HashMap();
    private static IArchive currentArchive;

    static {
        archives.put("FileSystem", new ArchivesFileSystem());
        archives.put("JarFile", new ArchivesJarFile());
    }

    public static Class[] getClasses(String packageName) {
        ClassFactory.setCurrentArchives(packageName);
        return currentArchive.getClasses(packageName, null);
    }

    public static Class[] getClasses(String packageName, Class cls) {
        ClassFactory.setCurrentArchives(packageName);
        return currentArchive.getClasses(packageName, cls);
    }

    public static Class[] getAllClasses(String packageName) {
        ClassFactory.setCurrentArchives(packageName);
        return currentArchive.getAllClasses(packageName);
    }

    public static Object createInstance(Class cls) {
        return currentArchive.createInstance(cls);
    }

    public static Object createInstance(String arg) {
        Class cls = currentArchive.getClass(arg);
        if (cls != null) {
            return currentArchive.createInstance(cls);
        }
        return null;
    }

    public static HashSet createInstances(String packageName) {
        ClassFactory.setCurrentArchives(packageName);
        return currentArchive.createInstances(packageName);
    }

    public static HashSet createAllInstances(String packageName) {
        ClassFactory.setCurrentArchives(packageName);
        return currentArchive.createAllInstances(packageName);
    }

    public static HashSet createInstances(String packageName, Class cls) {
        ClassFactory.setCurrentArchives(packageName);
        return currentArchive.createInstances(packageName, cls);
    }

    public static HashSet createAllInstances(String packageName, Class cls) {
        ClassFactory.setCurrentArchives(packageName);
        return currentArchive.createAllInstances(packageName, cls);
    }

    public static boolean match(Class cls, Class ... checkers) {
        int i = 0;
        while (i < checkers.length) {
            if (checkers[i].isAssignableFrom(cls)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void setCurrentArchives(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(name.replace(".", "/"));
        currentArchive = url != null ? archives.get("FileSystem") : archives.get("JarFile");
    }
}

