/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework.loader;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jp.sourceforge.sos.framework.loader.AbstractArchives;
import jp.sourceforge.sos.framework.loader.ICheckName;
import jp.sourceforge.sos.framework.loader.PluginClassLoader;

public class ArchivesJarFile
extends AbstractArchives {
    private PluginClassLoader loader;
    private ICheckName strategy;

    ArchivesJarFile() {
        String arg = System.getProperty("user.dir");
        this.loader = new PluginClassLoader(arg);
    }

    @Override
    Class[] getClasses(String name) {
        this.strategy = Strategy.CHILDREN;
        return this.fileToClass(name);
    }

    @Override
    public Class[] getAllClasses(String packageName) {
        this.strategy = Strategy.OFFSPINGS;
        return this.fileToClass(packageName);
    }

    private Class[] fileToClass(String packageName) {
        String name = packageName.replace(".", "/");
        ZipFile file = this.loader.getJar(name);
        Enumeration<? extends ZipEntry> entries = file.entries();
        HashSet<String> names = new HashSet<String>();
        while (entries.hasMoreElements()) {
            String finalName;
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(name) || (finalName = this.strategy.addName(name, entryName)) == null) continue;
            names.add(finalName);
        }
        return this.getClassesFromNames(names);
    }

    private Class[] getClassesFromNames(HashSet<String> names) {
        HashSet<Class> result = new HashSet<Class>();
        for (String clsName : names) {
            Class cls = this.getClass(clsName);
            if (cls == null) continue;
            result.add(cls);
        }
        return result.toArray(new Class[0]);
    }

    @Override
    Class loadClass(String className) {
        Class cls = null;
        try {
            System.out.println(className);
            cls = this.loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(0);
        }
        return cls;
    }

    private static enum Strategy implements ICheckName
    {
        CHILDREN{

            @Override
            public String addName(String packageName, String entryName) {
                String sub = entryName.substring(packageName.length() + 1);
                if (-1 < sub.indexOf("/")) {
                    return null;
                }
                return this.convert(entryName);
            }
        }
        ,
        OFFSPINGS{

            @Override
            public String addName(String packageName, String entryName) {
                return this.convert(entryName);
            }
        };


        protected String convert(String entryName) {
            String[] args = entryName.split("\\.");
            if (args[1].equals("class") && -1 == args[0].indexOf("$")) {
                return args[0].replace("/", ".");
            }
            return null;
        }
    }
}

