/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework.loader;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import jp.sourceforge.sos.framework.loader.AbstractArchives;

public class ArchivesFileSystem
extends AbstractArchives {
    private static final String CLASS_SUFFIX = ".class";

    private File getFile(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(name.replace(".", "/"));
        String fileName = this.decode(url.getFile());
        return new File(fileName);
    }

    @Override
    Class[] getClasses(String packageName) {
        File packageRoot = this.getFile(packageName);
        File[] files = packageRoot.listFiles();
        return this.fileToClass(packageName, files);
    }

    @Override
    public Class[] getAllClasses(String packageName) {
        File packageRoot = this.getFile(packageName);
        HashSet<File> allFiles = this.getChildrenFiles(packageRoot.listFiles());
        File[] files = allFiles.toArray(new File[allFiles.size()]);
        return this.fileToClass(packageName, files);
    }

    private HashSet<File> getChildrenFiles(File[] files) {
        HashSet<File> result = new HashSet<File>();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                result.add(files[i]);
            } else if (files[i].isDirectory()) {
                result.addAll(this.getChildrenFiles(files[i].listFiles()));
            }
            ++i;
        }
        return result;
    }

    private Class[] fileToClass(String rootPackageName, File[] files) {
        ArrayList<Class> result = new ArrayList<Class>();
        String packageName = rootPackageName.replace(".", File.separator);
        int i = 0;
        while (i < files.length) {
            String className = this.getClassName(packageName, files[i].getPath());
            Class cls = this.getClass(className);
            if (cls != null) {
                result.add(cls);
            }
            ++i;
        }
        return result.toArray(new Class[result.size()]);
    }

    protected String getClassName(String packageName, String path) {
        int index = path.indexOf(packageName);
        String arg = path.substring(index);
        String binaryName = arg.replace(File.separator, ".");
        return this.removeSuffix(binaryName);
    }

    protected String removeSuffix(String binaryName) {
        if (binaryName.endsWith(CLASS_SUFFIX)) {
            int offset = binaryName.length() - CLASS_SUFFIX.length();
            return binaryName.substring(0, offset);
        }
        return null;
    }

    @Override
    Class loadClass(String className) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(0);
        }
        return cls;
    }
}

