/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework.loader;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import jp.sourceforge.sos.framework.loader.IArchive;
import jp.sourceforge.sos.framework.util.SundaySingleton;

public abstract class AbstractArchives
implements IArchive {
    private static final Object[] NO_OBJECT = new Object[0];
    private static final Class[] NO_CLASS = new Class[0];
    private static HashMap<Class, Object> singletons = new HashMap();
    private static LinkedList<Class> classTypes = new LinkedList();
    protected static Class includeClassType = null;

    @Override
    public Class getClass(String className) {
        if (className == null) {
            return null;
        }
        Class cls = this.loadClass(className);
        if (includeClassType != null && !includeClassType.isAssignableFrom(cls)) {
            return null;
        }
        if (cls == null) {
            return null;
        }
        if (cls.getCanonicalName() == null) {
            return null;
        }
        return cls;
    }

    abstract Class loadClass(String var1);

    private void setIncludeClassType(Class inclusion) {
        classTypes.addLast(includeClassType);
        includeClassType = inclusion;
    }

    private void revertIncludeClassType() {
        includeClassType = classTypes.removeLast();
    }

    @Override
    public Class[] getClasses(String name, Class cls) {
        this.setIncludeClassType(cls);
        Class[] result = this.getClasses(name);
        this.revertIncludeClassType();
        return result;
    }

    abstract Class[] getClasses(String var1);

    protected String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object createInstance(Class cls) {
        if (cls == null) {
            return null;
        }
        if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) {
            return null;
        }
        Object obj = null;
        try {
            if (cls.isAnnotationPresent(SundaySingleton.class)) {
                obj = singletons.get(cls);
                if (obj == null) {
                    obj = this.create(cls);
                    singletons.put(cls, obj);
                }
            } else {
                obj = this.create(cls);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return obj;
    }

    private Object create(Class cls) {
        try {
            Constructor cons = cls.getDeclaredConstructor(NO_CLASS);
            cons.setAccessible(true);
            return cons.newInstance(NO_OBJECT);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.out.println(cls.getName());
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public HashSet createInstances(String packageName, Class cls) {
        this.setIncludeClassType(cls);
        HashSet result = this.createInstances(packageName);
        this.revertIncludeClassType();
        return result;
    }

    @Override
    public HashSet createAllInstances(String packageName, Class cls) {
        this.setIncludeClassType(cls);
        HashSet result = this.createAllInstances(packageName);
        this.revertIncludeClassType();
        return result;
    }

    private HashSet createInstances(Class[] classes) {
        HashSet<Object> set = new HashSet<Object>();
        int i = 0;
        while (i < classes.length) {
            Object obj = this.createInstance(classes[i]);
            if (obj != null) {
                set.add(obj);
            }
            ++i;
        }
        return set;
    }

    @Override
    public HashSet createInstances(String packageName) {
        Class[] classes = this.getClasses(packageName);
        return this.createInstances(classes);
    }

    @Override
    public HashSet createAllInstances(String packageName) {
        Class[] classes = this.getAllClasses(packageName);
        return this.createInstances(classes);
    }
}

