/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework.container;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import jp.sourceforge.sos.framework.container.AbstractVector;
import jp.sourceforge.sos.framework.container.ItemInVector;
import jp.sourceforge.sos.framework.loader.ClassFactory;
import jp.sourceforge.sos.framework.util.Factory;
import jp.sourceforge.sos.framework.view.ContainerInAncestor;
import jp.sourceforge.sos.framework.view.ContainerNotFoundException;

public class ManagerVector {
    private static final String PATH_VIEW_MAIN = ".main.ViewFrameMain.";
    private HashMap<String, Object> containers = new HashMap();
    private HashMap<Object, ArrayList<ItemInVector>> ligands = new HashMap();
    private String defaultAncestor;
    private String rootPath;
    private AbstractVector[] vectors;

    public ManagerVector(String arg) {
        this.rootPath = arg;
        this.defaultAncestor = String.valueOf(arg) + PATH_VIEW_MAIN;
        this.setupContainer();
        String packageName = this.getClass().getPackage().getName();
        this.vectors = (AbstractVector[])Factory.getInstances(packageName, AbstractVector.class);
    }

    private void setupContainer() {
        Class[] classes = ClassFactory.getAllClasses(this.rootPath);
        int i = 0;
        while (i < classes.length) {
            this.findContainer(classes[i]);
            ++i;
        }
    }

    private void findContainer(Class cls) {
        Field[] fields = cls.getDeclaredFields();
        boolean hasContainer = false;
        int i = 0;
        while (i < fields.length) {
            if (fields[i].isAnnotationPresent(ContainerInAncestor.class)) {
                hasContainer = true;
                break;
            }
            ++i;
        }
        if (hasContainer) {
            Object obj = ClassFactory.createInstance(cls);
            int i2 = 0;
            while (i2 < fields.length) {
                this.addContainer(obj, fields[i2]);
                ++i2;
            }
        }
    }

    private void addContainer(Object source, Field field) {
        if (field.isAnnotationPresent(ContainerInAncestor.class)) {
            field.setAccessible(true);
            try {
                Object container = field.get(source);
                String name = String.valueOf(source.getClass().getName()) + "." + field.getName();
                this.containers.put(name, container);
                this.ligands.put(container, new ArrayList());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void add(String targetName, ItemInVector obj) throws ContainerNotFoundException {
        Object container;
        if (targetName.indexOf(".") < 0) {
            targetName = String.valueOf(this.defaultAncestor) + targetName;
        }
        if ((container = this.containers.get(targetName)) == null) {
            String name = obj.getClass().getName();
            String message = String.valueOf(targetName) + " is not found. (needed in " + name + ")";
            throw new ContainerNotFoundException(message);
        }
        ArrayList<ItemInVector> list = this.ligands.get(container);
        int index = Factory.getInsertIndex(list, obj.getItem());
        Factory.addElement(list, obj, index);
    }

    public void implementLigands() {
        Set<Object> keys = this.ligands.keySet();
        for (Object container : keys) {
            this.selectStrategy(container);
        }
    }

    private void selectStrategy(Object container) {
        int i = 0;
        while (i < this.vectors.length) {
            if (this.vectors[i].isInstance(container)) {
                ArrayList<ItemInVector> list = this.ligands.get(container);
                for (ItemInVector item : list) {
                    this.vectors[i].add(container, item);
                }
                break;
            }
            ++i;
        }
    }
}

