/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.framework;

import jp.sourceforge.sos.framework.ILink;
import jp.sourceforge.sos.framework.ILinkIgnore;
import jp.sourceforge.sos.framework.ILinkModelAncestor;
import jp.sourceforge.sos.framework.ILinkMultiCast;
import jp.sourceforge.sos.framework.container.ItemInVector;
import jp.sourceforge.sos.framework.container.ManagerVector;
import jp.sourceforge.sos.framework.link.ManagerAutoLink;
import jp.sourceforge.sos.framework.loader.ClassFactory;
import jp.sourceforge.sos.framework.message.ManagerMultiCast;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.framework.model.ManagerModel;
import jp.sourceforge.sos.framework.util.ManagerInit;
import jp.sourceforge.sos.framework.util.SundaySingleton;
import jp.sourceforge.sos.framework.view.ContainerNotFoundException;

@SundaySingleton
public abstract class AbstractBuilder {
    private static Class[] ignoreClass = new Class[]{ILinkIgnore.class, AbstractModel.class};
    private String rootPath;
    private ManagerAutoLink autoLinkManager;
    private ManagerMultiCast multiCastManager;
    private ManagerModel modelManager;
    private ManagerVector containerManager;
    private ManagerInit initManager;

    protected AbstractBuilder() {
        this.setups();
        this.modelManager.build(this);
        this.containerManager.implementLigands();
        this.initManager.doInitialize();
    }

    private void setups() {
        this.rootPath = this.getClass().getPackage().getName();
        this.autoLinkManager = new ManagerAutoLink(this);
        this.initManager = new ManagerInit();
        this.modelManager = new ManagerModel();
        this.containerManager = new ManagerVector(this.rootPath);
        this.multiCastManager = new ManagerMultiCast(this.rootPath);
        AbstractModel.setBus(this.multiCastManager);
    }

    public void link(IComponent currentModel) {
        this.autoLinkManager.link(currentModel);
    }

    public void setModel(IComponent currentModel) {
        String packageName = currentModel.getClass().getPackage().getName();
        Class[] classes = ClassFactory.getClasses(packageName, ILink.class);
        int j = 0;
        while (j < classes.length) {
            Object obj = this.getInstance(classes[j]);
            this.autoLinkManager.link(obj);
            ++j;
        }
    }

    private Object getInstance(Class cls) {
        if (ClassFactory.match(cls, ignoreClass)) {
            return null;
        }
        return ClassFactory.createInstance(cls);
    }

    public void setToView(IComponent view) {
        view.setModel(this.modelManager.getCurrentModel());
    }

    public void addToContainer(String targetName, ItemInVector obj) {
        try {
            this.containerManager.add(targetName, obj);
        }
        catch (ContainerNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void addToBus(ILinkMultiCast obj) {
        this.multiCastManager.add(obj);
    }

    public void addToInitializer(Object obj) {
        this.initManager.add(obj);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setToView(ILinkModelAncestor view) {
        Class ancestor = view.getModel();
        view.setModel(this.modelManager.getModel(ancestor));
    }
}

