/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.window;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import jp.sourceforge.sos.lib.image.WritableImage;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.window.JImageFrame;

public class JImageArrayFrame
extends JImageFrame {
    private SOSImageIO imageIO = SOSImageIO.getInstance();
    private ArrayList<WritableImage> imageArray = new ArrayList();
    private JMenuBar jMenuBarMain;
    private JMenu jMenuFile;
    private JMenuItem jMenuSaveAll;
    private JMenuItem jMenuSaveCurrent;
    private JScrollBar jScrollBar;

    public JImageArrayFrame() {
        this.initComponents();
        this.jScrollBar.setMaximum(1);
    }

    public int getImageNumber() {
        return this.imageArray.size();
    }

    public void addImage(WritableImage img) {
        if (img != null) {
            this.imageArray.add(img);
            this.updateScrollBar();
        }
    }

    public void removeImage(int index) {
        if (index >= 0 && index < this.imageArray.size()) {
            this.imageArray.remove(index);
            this.updateScrollBar();
        }
    }

    public void clearImage() {
        this.imageArray.clear();
    }

    public void updateScrollBar() {
        int count = 0;
        for (WritableImage img : this.imageArray) {
            if (!img.isEnabled()) continue;
            ++count;
        }
        this.jScrollBar.setMaximum(count);
    }

    private void saveAllImage() {
        File parent = this.imageIO.getSaveDirectory();
        int i = 0;
        while (i < this.imageArray.size()) {
            File file = new File(String.valueOf(parent.getPath()) + File.separator + i);
            WritableImage img = this.imageArray.get(i);
            img.save(file, "png");
            ++i;
        }
    }

    private void saveImage() {
        File file = this.imageIO.getSaveFile();
        int index = this.imageIO.getFileType();
        WritableImage img = this.imageArray.get(this.jScrollBar.getValue());
        img.setEnabled(true);
        img.save(file, SOSImageIO.getMIME(index));
    }

    private void initComponents() {
        this.jScrollBar = new JScrollBar();
        this.jMenuBarMain = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuSaveCurrent = new JMenuItem();
        this.jMenuSaveAll = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setTitle("Image stack");
        this.jScrollBar.setOrientation(0);
        this.jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                JImageArrayFrame.this.setCurrentImage(JImageArrayFrame.this.jScrollBar.getValue());
            }
        });
        this.getContentPane().add((Component)this.jScrollBar, "South");
        this.jMenuFile.setText("File");
        this.jMenuSaveCurrent.setText("save current image");
        this.jMenuSaveCurrent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JImageArrayFrame.this.saveImage();
            }
        });
        this.jMenuFile.add(this.jMenuSaveCurrent);
        this.jMenuSaveAll.setText("save all images");
        this.jMenuSaveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JImageArrayFrame.this.saveAllImage();
            }
        });
        this.jMenuFile.add(this.jMenuSaveAll);
        this.jMenuBarMain.add(this.jMenuFile);
        this.setJMenuBar(this.jMenuBarMain);
        this.pack();
    }

    public void setCurrentImage(int index) {
        if (index >= 0 && index < this.imageArray.size()) {
            WritableImage img = this.imageArray.get(index);
            this.setImage(img.getImage());
        }
    }
}

