/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.vectors;

import java.util.Arrays;

public abstract class Vectors<T> {
    private int[] numbers;
    public int[] offsets;
    private int size;

    public void create(int dimension, int number) {
        int[] numbers = new int[dimension];
        Arrays.fill(numbers, number);
        this.create(numbers);
    }

    public void create(int[] numbers) {
        this.numbers = numbers;
        this.offsets = new int[numbers.length];
        int j = numbers.length - 1;
        this.size = 1;
        int i = 0;
        while (i < numbers.length) {
            this.offsets[j - i] = this.size;
            this.size *= numbers[j - i];
            ++i;
        }
        this.createArray(this.size);
    }

    public void create(int number) {
        this.create(new int[]{number});
    }

    public int[] toCoordination(int value) {
        int[] result = new int[this.offsets.length];
        int i = 0;
        while (i < result.length) {
            result[i] = value / this.offsets[i];
            value %= this.offsets[i];
            ++i;
        }
        return result;
    }

    public final int toIndex(int ... indices) {
        int index = 0;
        int i = 0;
        while (i < indices.length) {
            index += indices[i] * this.offsets[i];
            ++i;
        }
        return index;
    }

    public int size() {
        return this.size;
    }

    public int getDimension() {
        return this.numbers[this.numbers.length - 1];
    }

    public int getOffset() {
        return this.offsets[this.offsets.length - 1];
    }

    public abstract T getArray();

    protected abstract void createArray(int var1);

    public abstract void clear();

    public int getNumber(int i) {
        return this.numbers[i];
    }
}

